/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.reflection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jemoni.jmx.AttributeAccessor;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedUtils;

public class ReflectionBasedAttributeAccessor<T, B>
implements AttributeAccessor<T, B> {
    private final PropertyDescriptor _descriptor;

    @Nonnull
    public ReflectionBasedAttributeAccessor(@Nonnull PropertyDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return ReflectionBasedUtils.correctTypeIfNeeded(this._descriptor.getPropertyType());
    }

    @Override
    public void set(@Nonnull B bean, @Nullable T value) throws Exception {
        Method writeMethod = this._descriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new UnsupportedOperationException("Write is not supported on " + this + ".");
        }
        Class<T> type = this.getType();
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException("The provided value '" + value + "' is not of type " + type.getName() + ".");
        }
        writeMethod.invoke(bean, value);
    }

    @Override
    @Nullable
    public T get(@Nonnull B bean) throws Exception {
        Method readMethod = this._descriptor.getReadMethod();
        if (readMethod == null) {
            throw new UnsupportedOperationException("Read is not supported from " + this + ".");
        }
        Object value = readMethod.invoke(bean, new Object[0]);
        Class<T> type = this.getType();
        if (value != null && !type.isInstance(value)) {
            throw new IllegalStateException("The returned value '" + value + "' is not of expected type " + type.getName() + ".");
        }
        return type.cast(value);
    }
}

