/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.reflection;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jemoni.jmx.ArgumentDefinition;
import org.echocat.jemoni.jmx.OperationDefinition;
import org.echocat.jemoni.jmx.OperationInvoker;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedOperationInvoker;

public class ReflectionBasedOperationDefinition<B>
implements OperationDefinition<B> {
    private final Method _method;
    private String _name;
    private String _description;
    private OperationInvoker<B> _invoker;

    @Nonnull
    public ReflectionBasedOperationDefinition(@Nonnull Method method) {
        this._method = method;
        this.setName(null);
        this.setDescription(null);
        this.setInvoker(null);
    }

    @Override
    @Nonnull
    public String getName() {
        return this._name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this._description;
    }

    @Override
    @Nonnull
    public Class<?> getReturnType() {
        return this._invoker.getReturnType();
    }

    @Override
    @Nonnull
    public ArgumentDefinition[] getArgumentDefinitions() {
        return this._invoker.getArgumentDefinitions();
    }

    @Override
    public Object invoke(@Nonnull B bean, @Nonnull Object[] arguments) throws Exception {
        return this._invoker.invoke(bean, arguments);
    }

    public void setName(@Nullable String name) {
        this._name = !StringUtils.isEmpty((CharSequence)name) ? name : this._method.getName();
    }

    public void setDescription(@Nullable String description) {
        this._description = !StringUtils.isEmpty((CharSequence)description) ? description : null;
    }

    public void setInvoker(@Nullable OperationInvoker<B> invoker) {
        this._invoker = invoker != null ? invoker : this.getInvokerFor(this._method);
    }

    @Nonnull
    protected OperationInvoker<B> getInvokerFor(@Nonnull Method method) {
        return new ReflectionBasedOperationInvoker(method);
    }

    @Nonnull
    protected Method getMethod() {
        return this._method;
    }

    @Nonnull
    protected OperationInvoker<B> getInvoker() {
        return this._invoker;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReturnType().getName()).append(" ").append(this.getName()).append('(');
        boolean first = true;
        for (ArgumentDefinition argumentDefinition : this.getArgumentDefinitions()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(argumentDefinition.getType().getName()).append(' ').append(argumentDefinition.getName());
        }
        sb.append(')');
        return sb.toString();
    }
}

