/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jemoni.jmx.ArgumentDefinition;
import org.echocat.jemoni.jmx.OperationInvoker;
import org.echocat.jemoni.jmx.annotations.Argument;
import org.echocat.jemoni.jmx.reflection.ReflectionBasedUtils;

public class ReflectionBasedOperationInvoker<B>
implements OperationInvoker<B> {
    private final Method _method;
    private final ArgumentDefinition[] _argumentDefinitions;

    public ReflectionBasedOperationInvoker(@Nonnull Method method) {
        this._method = method;
        this._argumentDefinitions = this.getArgumentDefinitionsFor(method);
    }

    @Nonnull
    protected ArgumentDefinition[] getArgumentDefinitionsFor(@Nonnull Method method) {
        Class<?>[] types = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        ArgumentDefinition[] result = new ArgumentDefinition[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.getArgumentDefinitionFor(types[i], annotations[i], i);
        }
        return result;
    }

    @Override
    @Nonnull
    public Class<?> getReturnType() {
        return ReflectionBasedUtils.correctTypeIfNeeded(this._method.getReturnType());
    }

    @Override
    @Nonnull
    public ArgumentDefinition[] getArgumentDefinitions() {
        return this._argumentDefinitions;
    }

    @Override
    public Object invoke(@Nonnull B bean, @Nonnull Object[] arguments) throws Exception {
        return this._method.invoke(bean, arguments);
    }

    @Nonnull
    protected ArgumentDefinition getArgumentDefinitionFor(@Nonnull Class<?> type, @Nonnull Annotation[] annotation, int index) {
        Argument argument = this.findArgumentAnnotationIn(annotation);
        String nameFromArgument = argument != null ? argument.name() : null;
        String descriptionFromArgument = argument != null ? argument.description() : null;
        Class typeFromArgument = argument != null ? argument.type() : Argument.Null.class;
        return new ArgumentDefinitionImpl(Argument.Null.class.equals(typeFromArgument) ? type : typeFromArgument, StringUtils.isEmpty((CharSequence)nameFromArgument) ? "argument" + index : nameFromArgument, StringUtils.isEmpty((CharSequence)descriptionFromArgument) ? null : descriptionFromArgument);
    }

    @Nullable
    protected Argument findArgumentAnnotationIn(@Nonnull Annotation[] annotations) {
        Argument result = null;
        for (Annotation annotation : annotations) {
            if (!Argument.class.equals(annotation.annotationType())) continue;
            result = (Argument)annotation;
            break;
        }
        return result;
    }

    protected static class ArgumentDefinitionImpl
    implements ArgumentDefinition {
        private final Class<?> _type;
        private final String _name;
        private final String _description;

        public ArgumentDefinitionImpl(@Nonnull Class<?> type, @Nonnull String name, @Nullable String description) {
            this._type = type;
            this._name = name;
            this._description = description;
        }

        @Override
        @Nonnull
        public Class<?> getType() {
            return ReflectionBasedUtils.correctTypeIfNeeded(this._type);
        }

        @Override
        @Nonnull
        public String getName() {
            return this._name;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this._description;
        }
    }
}

