/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CacheListener;
import org.echocat.jomon.cache.ClearableCache;
import org.echocat.jomon.cache.KeysEnabledCache;
import org.echocat.jomon.cache.LimitedCache;
import org.echocat.jomon.cache.ListenerEnabledCache;
import org.echocat.jomon.cache.ProducingTypeEnabledCache;
import org.echocat.jomon.cache.StatisticsEnabledCache;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ProducingType;

public class CacheDynamicMBean
implements DynamicMBean {
    private final Cache<?, ?> _cache;

    public CacheDynamicMBean(@Nonnull Cache<?, ?> cache) {
        this._cache = cache;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object result;
        if ("type".equals(attribute)) {
            result = this._cache.getClass().getName();
        } else if ("keyType".equals(attribute)) {
            result = this._cache.getKeyType().getName();
        } else if ("valueType".equals(attribute)) {
            result = this._cache.getValueType().getName();
        } else if ("size".equals(attribute)) {
            result = this.cast(StatisticsEnabledCache.class).size();
        } else if ("hitRatio".equals(attribute)) {
            StatisticsEnabledCache statisticsEnabledCache = this.cast(StatisticsEnabledCache.class);
            Long numberOfHits = statisticsEnabledCache.getNumberOfHits();
            Long numberOfRequests = statisticsEnabledCache.getNumberOfRequests();
            result = numberOfHits != null && numberOfRequests != null ? Double.valueOf(numberOfRequests != 0L ? (double)numberOfHits.longValue() / (double)numberOfRequests.longValue() : 0.0) : null;
        } else if ("dropRatio".equals(attribute)) {
            StatisticsEnabledCache statisticsEnabledCache = this.cast(StatisticsEnabledCache.class);
            Long numberOfDrops = statisticsEnabledCache.getNumberOfDrops();
            Long numberOfRequests = statisticsEnabledCache.getNumberOfRequests();
            result = numberOfDrops != null && numberOfRequests != null ? Double.valueOf(numberOfRequests != 0L ? (double)numberOfDrops.longValue() / (double)numberOfRequests.longValue() : 0.0) : null;
        } else if ("numberOfMisses".equals(attribute)) {
            StatisticsEnabledCache statisticsEnabledCache = this.cast(StatisticsEnabledCache.class);
            Long numberOfHits = statisticsEnabledCache.getNumberOfHits();
            Long numberOfRequests = statisticsEnabledCache.getNumberOfRequests();
            result = numberOfHits != null && numberOfRequests != null ? Long.valueOf(numberOfRequests - numberOfHits) : null;
        } else if ("numberOfRequests".equals(attribute)) {
            result = this.cast(StatisticsEnabledCache.class).getNumberOfRequests();
        } else if ("numberOfHits".equals(attribute)) {
            result = this.cast(StatisticsEnabledCache.class).getNumberOfHits();
        } else if ("numberOfDrops".equals(attribute)) {
            result = this.cast(StatisticsEnabledCache.class).getNumberOfDrops();
        } else if ("created".equals(attribute)) {
            result = this.cast(StatisticsEnabledCache.class).getCreated();
        } else if ("maximumLifetime".equals(attribute)) {
            Duration maximumLifetime = this.cast(LimitedCache.class).getMaximumLifetime();
            result = maximumLifetime != null ? maximumLifetime.toString() : null;
        } else if ("capacity".equals(attribute)) {
            result = this.cast(LimitedCache.class).getCapacity();
        } else if ("producingType".equals(attribute)) {
            result = this.cast(ProducingTypeEnabledCache.class).getProducingType().name();
        } else if ("listeners".equals(attribute)) {
            Collection listeners = this.cast(ListenerEnabledCache.class).getListeners();
            result = this.getListenersAsString(listeners);
        } else {
            throw new AttributeNotFoundException();
        }
        return result;
    }

    @Nonnull
    protected String getListenersAsString(@Nonnull Collection<CacheListener> listeners) {
        StringBuilder sb = new StringBuilder();
        for (CacheListener listener : listeners) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(listener);
        }
        return sb.toString();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String attributeName = attribute.getName();
        Object value = attribute.getValue();
        if ("maximumLifetime".equals(attributeName)) {
            if (value != null && !(value instanceof String)) {
                throw new InvalidAttributeValueException();
            }
            this.cast(LimitedCache.class).setMaximumLifetime(value != null && !value.toString().trim().isEmpty() ? new Duration(value.toString()) : null);
        } else if ("capacity".equals(attributeName)) {
            if (value != null && !(value instanceof Number)) {
                throw new InvalidAttributeValueException();
            }
            this.cast(LimitedCache.class).setCapacity(value != null ? Long.valueOf(((Number)value).longValue()) : null);
        } else if ("producingType".equals(attributeName)) {
            ProducingType producingType;
            if (value != null && !(value instanceof String)) {
                throw new InvalidAttributeValueException();
            }
            if (value == null || value.toString().trim().isEmpty()) {
                producingType = ProducingType.DEFAULT;
            } else {
                try {
                    producingType = ProducingType.valueOf((String)value.toString().trim());
                }
                catch (IllegalArgumentException ignored) {
                    throw new InvalidAttributeValueException("Illegal value: " + value + ". Possible values: " + StringUtils.join((Object[])ProducingType.values(), (String)", "));
                }
            }
            this.cast(ProducingTypeEnabledCache.class).setProducingType(producingType);
        } else {
            throw new AttributeNotFoundException();
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object result;
        if ("clear".equals(actionName) && this._cache instanceof ClearableCache) {
            ((ClearableCache)this._cache).clear();
            result = null;
        } else if ("resetStatistics".equals(actionName) && this._cache instanceof StatisticsEnabledCache) {
            ((StatisticsEnabledCache)this._cache).resetStatistics();
            result = null;
        } else if ("getListeners".equals(actionName) && this._cache instanceof ListenerEnabledCache) {
            result = this.getListenersAsString(((ListenerEnabledCache)this._cache).getListeners());
        } else {
            if ("getKeys".equals(actionName) && this._cache instanceof KeysEnabledCache) {
                try (CloseableIterator iterator = ((KeysEnabledCache)this._cache).iterator();){
                    StringBuilder sb = new StringBuilder();
                    if (params.length > 0 && params[0] instanceof Number && ((Number)params[0]).intValue() >= 0) {
                        int limit = ((Number)params[0]).intValue();
                        for (int i = 0; iterator.hasNext() && i < limit; ++i) {
                            if (sb.length() > 0) {
                                sb.append('\n');
                            }
                            sb.append(iterator.next());
                        }
                    } else {
                        while (iterator.hasNext()) {
                            if (sb.length() > 0) {
                                sb.append('\n');
                            }
                            sb.append(iterator.next());
                        }
                    }
                    result = sb.toString();
                }
            }
            if ("get".equals(actionName)) {
                String key = params.length > 0 && params[0] != null ? params[0].toString() : null;
                Object plainResult = this._cache.get(key);
                result = plainResult != null ? plainResult.toString() : null;
            } else if ("remove".equals(actionName)) {
                String key = params.length > 0 && params[0] != null ? params[0].toString() : null;
                this._cache.remove(key);
                result = null;
            } else if ("contains".equals(actionName)) {
                String key = params.length > 0 && params[0] != null ? params[0].toString() : null;
                result = this._cache.contains(key);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this._cache.getClass().getName(), null, this.getAttributes(), null, this.getOperations(), null);
    }

    @Nonnull
    protected MBeanAttributeInfo[] getAttributes() {
        ArrayList<MBeanAttributeInfo> result = new ArrayList<MBeanAttributeInfo>();
        result.add(new MBeanAttributeInfo("type", String.class.getName(), null, true, false, false));
        result.add(new MBeanAttributeInfo("keyType", String.class.getName(), null, true, false, false));
        result.add(new MBeanAttributeInfo("valueType", String.class.getName(), null, true, false, false));
        if (this._cache instanceof StatisticsEnabledCache) {
            result.add(new MBeanAttributeInfo("size", Long.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("hitRatio", Double.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("dropRatio", Double.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("numberOfRequests", Long.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("numberOfHits", Long.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("numberOfDrops", Long.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("numberOfMisses", Long.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("created", Date.class.getName(), null, true, false, false));
        }
        if (this._cache instanceof LimitedCache) {
            result.add(new MBeanAttributeInfo("maximumLifetime", String.class.getName(), null, true, true, false));
            result.add(new MBeanAttributeInfo("capacity", Long.class.getName(), null, true, true, false));
        }
        if (this._cache instanceof ListenerEnabledCache) {
            result.add(new MBeanAttributeInfo("listeners", String.class.getName(), null, true, false, false));
        }
        if (this._cache instanceof ProducingTypeEnabledCache) {
            result.add(new MBeanAttributeInfo("producingType", String.class.getName(), null, true, true, false));
        }
        return result.toArray(new MBeanAttributeInfo[result.size()]);
    }

    @Nonnull
    protected MBeanOperationInfo[] getOperations() {
        ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>();
        result.add(new MBeanOperationInfo("get", null, new MBeanParameterInfo[]{new MBeanParameterInfo("key", String.class.getName(), null)}, String.class.getName(), 1));
        result.add(new MBeanOperationInfo("remove", null, new MBeanParameterInfo[]{new MBeanParameterInfo("key", String.class.getName(), null)}, Void.TYPE.getName(), 1));
        result.add(new MBeanOperationInfo("contains", null, new MBeanParameterInfo[]{new MBeanParameterInfo("key", String.class.getName(), null)}, Boolean.TYPE.getName(), 1));
        if (this._cache instanceof KeysEnabledCache) {
            result.add(new MBeanOperationInfo("getKeys", null, new MBeanParameterInfo[]{new MBeanParameterInfo("limit", Integer.class.getName(), null)}, String.class.getName(), 1));
        }
        if (this._cache instanceof ClearableCache) {
            result.add(new MBeanOperationInfo("clear", null, new MBeanParameterInfo[0], Void.TYPE.getName(), 1));
        }
        if (this._cache instanceof StatisticsEnabledCache) {
            result.add(new MBeanOperationInfo("resetStatistics", null, new MBeanParameterInfo[0], Void.TYPE.getName(), 1));
        }
        if (this._cache instanceof ListenerEnabledCache) {
            result.add(new MBeanOperationInfo("getListeners", null, new MBeanParameterInfo[0], String.class.getName(), 1));
        }
        return result.toArray(new MBeanOperationInfo[result.size()]);
    }

    @Nonnull
    protected <T extends Cache<?, ?>> T cast(@Nonnull Class<T> type) throws AttributeNotFoundException {
        if (type.isInstance(this._cache)) {
            return (T)((Cache)type.cast(this._cache));
        }
        throw new AttributeNotFoundException();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }
}

