/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.echocat.jemoni.jmx.JmxRegistry;
import org.echocat.jemoni.jmx.Registration;
import org.echocat.jomon.net.cluster.channel.AddressEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.BlockableClusterChannel;
import org.echocat.jomon.net.cluster.channel.ClusterChannel;
import org.echocat.jomon.net.cluster.channel.ClusterChannelUtils;
import org.echocat.jomon.net.cluster.channel.DropMessagesEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.NetBasedClusterChannel;
import org.echocat.jomon.net.cluster.channel.PingEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.RemoteAddressesEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.SendingQueueEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.ServiceEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.StatisticEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.multicast.MulticastClusterChannel;
import org.echocat.jomon.net.cluster.channel.tcp.TcpClusterChannel;
import org.echocat.jomon.runtime.jaxb.InetSocketAddressPropertyEditor;
import org.echocat.jomon.runtime.util.Duration;

public class ClusterChannelMBean
implements DynamicMBean,
AutoCloseable {
    private final ClusterChannel<?, ?> _channel;
    private final Registration _registration;

    public ClusterChannelMBean(@Nonnull ClusterChannel<?, ?> clusterChannel, @Nonnull JmxRegistry registry) {
        this._channel = clusterChannel;
        this._registration = registry.register(this, ClusterChannel.class, clusterChannel.getName());
    }

    @Override
    public void close() throws Exception {
        this._registration.close();
    }

    @Nonnull
    public ClusterChannel<?, ?> getChannel() {
        return this._channel;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object result;
        if ("name".equals(attribute)) {
            result = this._channel.getName();
        } else if ("id".equals(attribute)) {
            result = this._channel.getId().toString();
        } else if ("uuid".equals(attribute)) {
            result = this._channel.getUuid().toString();
        } else if ("service".equals(attribute)) {
            result = this.castForAttribute(ServiceEnabledClusterChannel.class).getService();
        } else if ("pingInterval".equals(attribute)) {
            result = this.castForAttribute(PingEnabledClusterChannel.class).getPingInterval().toString();
        } else if ("pingIntervalToTimeoutRatio".equals(attribute)) {
            result = this.castForAttribute(MulticastClusterChannel.class).getPingIntervalToTimeoutRatio();
        } else if ("lastPingSend".equals(attribute)) {
            result = this.castForAttribute(PingEnabledClusterChannel.class).getLastPingSendAt();
        } else if ("messagesReceivedPerSecond".equals(attribute)) {
            result = this.castForAttribute(StatisticEnabledClusterChannel.class).getMessagesReceivedPerSecond();
        } else if ("messagesSendPerSecond".equals(attribute)) {
            result = this.castForAttribute(StatisticEnabledClusterChannel.class).getMessagesSendPerSecond();
        } else if ("messagesReceived".equals(attribute)) {
            result = this.castForAttribute(StatisticEnabledClusterChannel.class).getMessagesReceived();
        } else if ("messagesSend".equals(attribute)) {
            result = this.castForAttribute(StatisticEnabledClusterChannel.class).getMessagesSend();
        } else if ("lastMessageReceived".equals(attribute)) {
            result = this.castForAttribute(StatisticEnabledClusterChannel.class).getLastMessageReceived();
        } else if ("lastMessageSend".equals(attribute)) {
            result = this.castForAttribute(StatisticEnabledClusterChannel.class).getLastMessageSend();
        } else if ("nodesStatus".equals(attribute)) {
            result = ClusterChannelUtils.formatNodesStatusOf(this._channel);
        } else if ("ttl".equals(attribute)) {
            result = this.castForAttribute(MulticastClusterChannel.class).getTtl().toString();
        } else if ("soTimeout".equals(attribute)) {
            result = this.castForAttribute(NetBasedClusterChannel.class).getSoTimeout().toString();
        } else if ("connectionTimeout".equals(attribute)) {
            result = this.castForAttribute(TcpClusterChannel.class).getConnectionTimeout().toString();
        } else if ("address".equals(attribute)) {
            InetSocketAddress address = this.castForAttribute(AddressEnabledClusterChannel.class).getAddress();
            result = address != null ? address.getHostString() + ":" + address.getPort() : null;
        } else if ("remoteAddresses".equals(attribute)) {
            result = this.castForAttribute(RemoteAddressesEnabledClusterChannel.class).getRemoteAddressesAsString();
        } else if ("sendingQueueCapacity".equals(attribute)) {
            result = this.castForAttribute(SendingQueueEnabledClusterChannel.class).getSendingQueueCapacity();
        } else if ("sendingQueueSize".equals(attribute)) {
            result = this.castForAttribute(SendingQueueEnabledClusterChannel.class).getSendingQueueSize();
        } else if ("blocking".equals(attribute)) {
            result = this.castForAttribute(BlockableClusterChannel.class).isBlocking();
        } else if ("dropMessagesIfQueueIsFull".equals(attribute)) {
            result = this.castForAttribute(DropMessagesEnabledClusterChannel.class).isDropMessagesIfQueueIsFull();
        } else {
            throw new AttributeNotFoundException();
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String attributeName = attribute.getName();
        Object value = attribute.getValue();
        if ("name".equals(attributeName)) {
            this._channel.setName(this.cast(String.class, value));
        } else if ("service".equals(attributeName)) {
            this.castForAttribute(ServiceEnabledClusterChannel.class).setService(this.cast(String.class, value));
        } else if ("pingInterval".equals(attributeName)) {
            this.castForAttribute(PingEnabledClusterChannel.class).setPingInterval(new Duration(this.cast(String.class, value)));
        } else if ("pingIntervalToTimeoutRatio".equals(attributeName)) {
            this.castForAttribute(MulticastClusterChannel.class).setPingIntervalToTimeoutRatio(this.cast(Number.class, value).doubleValue());
        } else if ("ttl".equals(attributeName)) {
            this.castForAttribute(MulticastClusterChannel.class).setTtl(new Duration(this.cast(String.class, value)));
        } else if ("soTimeout".equals(attributeName)) {
            this.castForAttribute(NetBasedClusterChannel.class).setSoTimeout(new Duration(this.cast(String.class, value)));
        } else if ("connectionTimeout".equals(attributeName)) {
            this.castForAttribute(TcpClusterChannel.class).setConnectionTimeout(new Duration(this.cast(String.class, value)));
        } else if ("sendingQueueCapacity".equals(attributeName)) {
            this.castForAttribute(SendingQueueEnabledClusterChannel.class).setSendingQueueCapacity(this.cast(Number.class, value).intValue());
        } else if ("blocking".equals(attributeName)) {
            this.castForAttribute(BlockableClusterChannel.class).setBlocking(Boolean.TRUE.equals(this.cast(Boolean.class, value)));
        } else if ("dropMessagesIfQueueIsFull".equals(attributeName)) {
            this.castForAttribute(DropMessagesEnabledClusterChannel.class).setDropMessagesIfQueueIsFull(Boolean.TRUE.equals(this.cast(Boolean.class, value)));
        } else if ("address".equals(attributeName)) {
            if (value != null) {
                InetSocketAddressPropertyEditor editor = new InetSocketAddressPropertyEditor();
                editor.setAsText(this.cast(String.class, value));
                this.castForAttribute(AddressEnabledClusterChannel.class).setAddress((InetSocketAddress)editor.getValue());
            } else {
                this.castForAttribute(AddressEnabledClusterChannel.class).setAddress(null);
            }
        } else if ("remoteAddresses".equals(attributeName)) {
            this.castForAttribute(RemoteAddressesEnabledClusterChannel.class).setRemoteAddressesAsString(this.cast(String.class, value));
        } else {
            throw new AttributeNotFoundException();
        }
    }

    private <T> T cast(@Nonnull Class<T> type, @Nullable Object value) throws InvalidAttributeValueException {
        if (!type.isInstance(value)) {
            throw new InvalidAttributeValueException();
        }
        return type.cast(value);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        String result;
        if ("ping".equals(actionName)) {
            this.castForOperation(PingEnabledClusterChannel.class).ping();
            result = null;
        } else if ("getNodeStatus".equals(actionName)) {
            result = ClusterChannelUtils.formatNodesStatusOf(this._channel);
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this._channel.getClass().getName(), null, this.getAttributesArray(), null, this.getOperationsArray(), null);
    }

    @Nonnull
    protected MBeanAttributeInfo[] getAttributesArray() {
        List<MBeanAttributeInfo> result = this.getAttributes();
        return result.toArray(new MBeanAttributeInfo[result.size()]);
    }

    @Nonnull
    protected List<MBeanAttributeInfo> getAttributes() {
        ArrayList<MBeanAttributeInfo> result = new ArrayList<MBeanAttributeInfo>();
        result.add(new MBeanAttributeInfo("id", String.class.getName(), null, true, false, false));
        result.add(new MBeanAttributeInfo("uuid", String.class.getName(), null, true, false, false));
        result.add(new MBeanAttributeInfo("name", String.class.getName(), null, true, true, false));
        result.add(new MBeanAttributeInfo("nodesStatus", String.class.getName(), null, true, false, false));
        if (this._channel instanceof PingEnabledClusterChannel) {
            result.add(new MBeanAttributeInfo("pingInterval", String.class.getName(), null, true, true, false));
            result.add(new MBeanAttributeInfo("lastPingSend", Date.class.getName(), null, true, false, false));
        }
        if (this._channel instanceof StatisticEnabledClusterChannel) {
            result.add(new MBeanAttributeInfo("messagesReceivedPerSecond", Double.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("messagesSendPerSecond", Double.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("messagesReceived", Long.class.getName(), null, true, false, false));
            result.add(new MBeanAttributeInfo("messagesSend", Long.class.getName(), null, true, false, false));
        }
        if (this._channel instanceof AddressEnabledClusterChannel) {
            result.add(new MBeanAttributeInfo("address", String.class.getName(), null, true, true, false));
        }
        if (this._channel instanceof RemoteAddressesEnabledClusterChannel) {
            result.add(new MBeanAttributeInfo("remoteAddresses", String.class.getName(), null, true, true, false));
        }
        if (this._channel instanceof ServiceEnabledClusterChannel) {
            result.add(new MBeanAttributeInfo("service", String.class.getName(), null, true, true, false));
        }
        if (this._channel instanceof BlockableClusterChannel) {
            result.add(new MBeanAttributeInfo("blocking", Boolean.class.getName(), null, true, true, false));
        }
        if (this._channel instanceof DropMessagesEnabledClusterChannel) {
            result.add(new MBeanAttributeInfo("dropMessagesIfQueueIsFull", Boolean.class.getName(), null, true, true, false));
        }
        if (this._channel instanceof SendingQueueEnabledClusterChannel) {
            result.add(new MBeanAttributeInfo("sendingQueueCapacity", Integer.class.getName(), null, true, true, false));
            result.add(new MBeanAttributeInfo("sendingQueueSize", Integer.class.getName(), null, true, false, false));
        }
        if (this._channel instanceof NetBasedClusterChannel) {
            result.add(new MBeanAttributeInfo("soTimeout", String.class.getName(), null, true, true, false));
        }
        if (this._channel instanceof TcpClusterChannel) {
            result.add(new MBeanAttributeInfo("connectionTimeout", String.class.getName(), null, true, true, false));
        }
        if (this._channel instanceof MulticastClusterChannel) {
            result.add(new MBeanAttributeInfo("pingIntervalToTimeoutRatio", Double.class.getName(), null, true, true, false));
            result.add(new MBeanAttributeInfo("ttl", String.class.getName(), null, true, true, false));
        }
        return result;
    }

    @Nonnull
    protected MBeanOperationInfo[] getOperationsArray() {
        List<MBeanOperationInfo> result = this.getOperations();
        return result.toArray(new MBeanOperationInfo[result.size()]);
    }

    @Nonnull
    protected List<MBeanOperationInfo> getOperations() {
        ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>();
        if (this._channel instanceof PingEnabledClusterChannel) {
            result.add(new MBeanOperationInfo("ping", null, new MBeanParameterInfo[0], Void.TYPE.getName(), 1));
        }
        result.add(new MBeanOperationInfo("getNodeStatus", null, new MBeanParameterInfo[0], String.class.getName(), 1));
        return result;
    }

    @Nonnull
    protected <T extends ClusterChannel<?, ?>> T castForAttribute(@Nonnull Class<T> type) throws AttributeNotFoundException {
        if (type.isInstance(this._channel)) {
            return (T)((ClusterChannel)type.cast(this._channel));
        }
        throw new AttributeNotFoundException();
    }

    @Nonnull
    protected <T extends ClusterChannel<?, ?>> T castForOperation(@Nonnull Class<T> type) throws MBeanException {
        if (type.isInstance(this._channel)) {
            return (T)((ClusterChannel)type.cast(this._channel));
        }
        throw new MBeanException(null, "Illegal method.");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }
}

