/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import org.echocat.jemoni.jmx.support.ServletHealth;
import org.echocat.jemoni.jmx.support.ServletHealthInterceptor;
import org.echocat.jomon.runtime.CollectionUtils;

public class CombinedServletHealthInterceptor
implements ServletHealthInterceptor {
    private Iterable<ServletHealthInterceptor> _interceptors;

    public CombinedServletHealthInterceptor() {
        this((Iterable<ServletHealthInterceptor>)null);
    }

    public CombinedServletHealthInterceptor(@Nullable Iterable<ServletHealthInterceptor> interceptors) {
        this._interceptors = interceptors;
    }

    public CombinedServletHealthInterceptor(ServletHealthInterceptor ... interceptors) {
        this(interceptors != null ? CollectionUtils.asImmutableList((Object[])interceptors) : null);
    }

    public Iterable<ServletHealthInterceptor> getInterceptors() {
        return this._interceptors;
    }

    public void setInterceptors(Iterable<ServletHealthInterceptor> interceptors) {
        this._interceptors = interceptors;
    }

    @Override
    public boolean isRecordAllowed(@Nonnull ServletRequest request, @Nonnull ServletHealth.ScopeMapping globalMapping, @Nullable ServletHealth.ScopeMapping specificMapping) {
        boolean result = true;
        Iterable<ServletHealthInterceptor> interceptors = this._interceptors;
        if (interceptors != null) {
            for (ServletHealthInterceptor interceptor : interceptors) {
                if (interceptor.isRecordAllowed(request, globalMapping, specificMapping)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    @Nullable
    public String getSpecificTargetName(@Nonnull ServletRequest request, @Nonnull ServletHealth.ScopeMapping specificMapping) {
        String result;
        block1: {
            ServletHealthInterceptor interceptor;
            result = null;
            Iterable<ServletHealthInterceptor> interceptors = this._interceptors;
            if (interceptors == null) break block1;
            Iterator<ServletHealthInterceptor> iterator = interceptors.iterator();
            while (iterator.hasNext() && (result = (interceptor = iterator.next()).getSpecificTargetName(request, specificMapping)) == null) {
            }
        }
        return result;
    }

    @Override
    @Nullable
    public Collection<String> getPossibleNames(@Nonnull String defaultName) {
        LinkedHashSet<String> result = null;
        Iterable<ServletHealthInterceptor> interceptors = this._interceptors;
        if (interceptors != null) {
            for (ServletHealthInterceptor interceptor : interceptors) {
                Collection<String> possibleNamesOfInterceptor = interceptor.getPossibleNames(defaultName);
                if (possibleNamesOfInterceptor == null) continue;
                if (result == null) {
                    result = new LinkedHashSet<String>();
                }
                result.addAll(possibleNamesOfInterceptor);
            }
        }
        return result;
    }
}

