/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jemoni.jmx.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.echocat.jemoni.jmx.JmxRegistry;
import org.echocat.jemoni.jmx.Registration;
import org.echocat.jemoni.jmx.support.CacheDynamicMBean;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CreationCacheListener;
import org.echocat.jomon.cache.management.DestroyCacheListener;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class JmxCacheRepositoryListener
implements CreationCacheListener,
DestroyCacheListener {
    private final JmxRegistry _registry;
    private final Map<String, Registration> _idToRegistration = new ConcurrentHashMap<String, Registration>();

    public JmxCacheRepositoryListener(@Nonnull JmxRegistry registry) {
        this._registry = registry;
    }

    public void afterCreate(@Nonnull String id, @Nonnull CacheDefinition<?, ?, ?> definition, @Nonnull Cache<?, ?> cache) {
        Registration registration = this._registry.register(new CacheDynamicMBean(cache), Cache.class, id);
        this._idToRegistration.put(id, registration);
    }

    public boolean beforeDestroy(@Nonnull String id, @Nonnull Cache<?, ?> cache) {
        Registration registration = this._idToRegistration.get(id);
        if (registration != null) {
            ResourceUtils.closeQuietly((AutoCloseable)registration);
        }
        return true;
    }

    public boolean beforeCreate(@Nonnull String id, @Nonnull CacheDefinition<?, ?, ?> definition) {
        return true;
    }

    public void afterDestroy(@Nonnull String id, @Nonnull Cache<?, ?> cache) {
    }
}

