/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.format.FormatProvider;
import org.echocat.jomon.format.FormatProviderSupport;
import org.echocat.jomon.format.Source;
import org.echocat.jomon.format.Target;
import org.echocat.jomon.runtime.util.Hints;

@ThreadSafe
@Immutable
public class CombinedFormatProvider
extends FormatProviderSupport {
    private static final CombinedFormatProvider INSTANCE = new CombinedFormatProvider();
    @Nonnull
    private final List<FormatProvider> _delegates;

    @Nonnull
    public static FormatProvider formatProvider() {
        return INSTANCE;
    }

    @Nonnull
    public static List<FormatProvider> getSystemProviders(@Nullable ClassLoader classLoader) {
        ServiceLoader<FormatProvider> providers = classLoader != null ? ServiceLoader.load(FormatProvider.class, classLoader) : ServiceLoader.load(FormatProvider.class);
        ArrayList<FormatProvider> result = new ArrayList<FormatProvider>();
        for (FormatProvider provider : providers) {
            result.add(provider);
        }
        return Collections.unmodifiableList(result);
    }

    public CombinedFormatProvider(@Nullable List<FormatProvider> delegates) {
        this._delegates = delegates != null ? delegates : Collections.emptyList();
    }

    public CombinedFormatProvider(@Nullable ClassLoader classLoader) {
        this(CombinedFormatProvider.getSystemProviders(classLoader));
    }

    public CombinedFormatProvider() {
        this((ClassLoader)null);
    }

    @Override
    public Source.Format findSourceFormatBy(@Nonnull String name, @Nullable Hints hints) {
        FormatProvider delegate;
        Source.Format result = null;
        Iterator<FormatProvider> i$ = this._delegates.iterator();
        while (i$.hasNext() && (result = (delegate = i$.next()).findSourceFormatBy(name, hints)) == null) {
        }
        return result;
    }

    @Override
    public Target.Format findTargetFormatBy(@Nonnull String name, @Nullable Hints hints) {
        FormatProvider delegate;
        Target.Format result = null;
        Iterator<FormatProvider> i$ = this._delegates.iterator();
        while (i$.hasNext() && (result = (delegate = i$.next()).findTargetFormatBy(name, hints)) == null) {
        }
        return result;
    }

    @Nonnull
    public List<FormatProvider> getDelegates() {
        return this._delegates;
    }
}

