/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format.mylyn;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.format.FormatUtils;
import org.echocat.jomon.format.FormatterSupport;
import org.echocat.jomon.format.Source;
import org.echocat.jomon.format.Target;
import org.echocat.jomon.format.mylyn.MylynAssignmentsSupport;
import org.echocat.jomon.format.mylyn.MylynDocumentBuilders;
import org.echocat.jomon.format.mylyn.MylynMarkupLanguages;
import org.echocat.jomon.runtime.util.Hints;

public class MylynWikitextFormatter
extends FormatterSupport {
    public static final String MARKUP_PARSER_TYPE_NAME = "org.eclipse.mylyn.wikitext.core.parser.MarkupParser";
    private final MylynMarkupLanguages _markupLanguages;
    private final MylynDocumentBuilders _documentBuilders;
    private final Class<?> _markupParserType;
    private final Class<?> _documentBuilderType;
    private final Class<?> _markupLanguageType;
    private final Method _setMarkupLanguage;
    private final Method _setBuilder;
    private final Method _parse;
    private final boolean _validLoaded;

    public MylynWikitextFormatter(@Nullable ClassLoader classLoader, @Nullable MylynMarkupLanguages markupLanguages, @Nullable MylynDocumentBuilders documentBuilders) {
        ClassLoader targetClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        this._markupLanguages = markupLanguages != null ? markupLanguages : new MylynMarkupLanguages(targetClassLoader);
        this._documentBuilders = documentBuilders != null ? documentBuilders : new MylynDocumentBuilders(targetClassLoader);
        this._markupParserType = MylynAssignmentsSupport.findType(targetClassLoader, MARKUP_PARSER_TYPE_NAME);
        this._documentBuilderType = MylynDocumentBuilders.findDocumentBuilderType(targetClassLoader);
        this._markupLanguageType = MylynMarkupLanguages.findMarkupLanguageType(targetClassLoader);
        this._setMarkupLanguage = this._markupParserType != null && this._markupLanguageType != null ? MylynWikitextFormatter.loadMethod(this._markupParserType, "setMarkupLanguage", this._markupLanguageType) : null;
        this._setBuilder = this._markupParserType != null && this._documentBuilderType != null ? MylynWikitextFormatter.loadMethod(this._markupParserType, "setBuilder", this._documentBuilderType) : null;
        this._parse = this._markupParserType != null ? MylynWikitextFormatter.loadMethod(this._markupParserType, "parse", Reader.class, Boolean.TYPE) : null;
        this._validLoaded = this._documentBuilderType != null && this._markupLanguageType != null && this._markupLanguageType != null && this._setMarkupLanguage != null && this._setBuilder != null && this._parse != null;
    }

    public MylynWikitextFormatter() {
        this(null, null, null);
    }

    @Override
    public void format(@Nonnull Source source, @Nonnull Target target, @Nullable Hints hints) throws IllegalArgumentException, IOException {
        if (!this.canHandle(source, target, hints)) {
            throw new IllegalArgumentException("Could not handle the combination of " + source + " and " + target + ".");
        }
        Target.Format requestedTargetFormat = target.getFormat();
        Target.Format targetFormat = Target.Format.textPlain.equals(requestedTargetFormat) ? Target.Format.html : requestedTargetFormat;
        Writer writer = targetFormat.equals(requestedTargetFormat) ? target.getWriter() : new StringWriter();
        Object markupLanguage = this.createMarkupLanguageFor(source);
        Object documentBuilder = this.createDocumentBuilderFor(targetFormat, writer);
        Object markupParser = this.createMarkupParser(markupLanguage, documentBuilder);
        this.formatWith(source.getReader(), markupParser);
        if (!targetFormat.equals(requestedTargetFormat)) {
            FormatUtils.htmlToPlainText(new StringReader(writer.toString()), target.getWriter());
        }
    }

    protected void formatWith(@Nonnull Reader reader, @Nonnull Object markupParser) throws IOException {
        try {
            this._parse.invoke(markupParser, reader, false);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new RuntimeException("Could not parse.", target != null ? target : e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse.", e);
        }
    }

    @Nonnull
    protected Object createMarkupParser(@Nonnull Object markupLanguage, @Nonnull Object documentBuilder) {
        try {
            Object markupParser = this._markupParserType.newInstance();
            this._setMarkupLanguage.invoke(markupParser, markupLanguage);
            this._setBuilder.invoke(markupParser, documentBuilder);
            return markupParser;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create parser.", e);
        }
    }

    @Nonnull
    protected Object createMarkupLanguageFor(@Nonnull Source source) throws IllegalArgumentException {
        return this.createLanguageFor(source.getFormat());
    }

    @Nonnull
    protected Object createLanguageFor(@Nonnull Source.Format format) throws IllegalArgumentException {
        Class<?> type = this._markupLanguages.findTypeFor(format);
        if (type == null) {
            throw new IllegalArgumentException("Could not handle source format " + format + ".");
        }
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of " + type.getName() + " to handle source of format " + format + ".", e);
        }
    }

    @Nonnull
    protected Object createDocumentBuilderFor(@Nonnull Target.Format format, @Nonnull Writer writer) throws IOException {
        Class<?> type = this._documentBuilders.findTypeFor(format);
        if (type == null) {
            throw new IllegalArgumentException("Could not handle target format " + format + ".");
        }
        try {
            Constructor<?> constructor = type.getConstructor(Writer.class);
            return constructor.newInstance(writer);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of " + type.getName() + " to handle target of format " + format + ".", e);
        }
    }

    @Override
    public boolean canHandle(@Nonnull Source source, @Nonnull Target target, @Nullable Hints hints) {
        return this._validLoaded && this.canHandle(source) && this.canHandle(target);
    }

    protected boolean canHandle(@Nonnull Source source) {
        return this._markupLanguages.findTypeFor(source.getFormat()) != null;
    }

    protected boolean canHandle(@Nonnull Target target) {
        Target.Format requestedTargetFormat = target.getFormat();
        Target.Format targetFormat = Target.Format.textPlain.equals(requestedTargetFormat) ? Target.Format.html : requestedTargetFormat;
        return this._documentBuilders.findTypeFor(targetFormat) != null;
    }

    @Nonnull
    protected static Method loadMethod(@Nonnull Class<?> from, @Nonnull String name, Class<?> ... parameterTypes) {
        try {
            return from.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ignored) {
            throw new IllegalStateException("Could not find the method " + name + "(" + StringUtils.join((Object[])parameterTypes) + ") at " + from.getName() + ".");
        }
    }
}

