/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.mail;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.echocat.jomon.net.mail.Mail;
import org.echocat.jomon.net.mail.MailSender;
import org.echocat.jomon.runtime.ImmutableMimeType;
import org.echocat.jomon.runtime.StringUtils;

public class SmtpSender
implements MailSender {
    private InetSocketAddress _server;
    private Authentication _authentication;
    private String _defaultSenderAddress;
    private String _defaultPersonal;

    public void setServer(@Nonnull InetSocketAddress server) {
        this._server = server;
    }

    public void setServerUri(@Nonnull URI server) {
        if (!"smtp".equals(server.getScheme())) {
            throw new IllegalArgumentException("Illegal scheme of: " + server);
        }
        String host = server.getHost();
        int port = server.getPort();
        this._server = new InetSocketAddress(host, port >= 0 ? port : 25);
    }

    public void setAuthentication(@Nonnull Authentication authentication) {
        this._authentication = authentication;
    }

    public void setUsernameAndPassword(@Nonnull String authenticationString) {
        String[] args = StringUtils.split((String)authenticationString, (String)":", (int)2);
        if (args.length != 2) {
            throw new IllegalArgumentException("<username>:<password> required but got: " + authenticationString);
        }
        this._authentication = new Authentication(args[0], args[1]);
    }

    public void setDefaultSenderAddress(@Nonnull String defaultSenderAddress) {
        this._defaultSenderAddress = defaultSenderAddress;
    }

    public void setDefaultPersonal(@Nonnull String defaultPersonal) {
        this._defaultPersonal = defaultPersonal;
    }

    @Override
    public void send(@Nonnull Mail mail) throws MailSender.MailSenderException {
        this.checkMail(mail);
        Session session = Session.getDefaultInstance((Properties)this.createProperties(), (Authenticator)this._authentication);
        Message message = this.toMessage(mail, session);
        try {
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new MailSender.MailSenderException("Could not send message, please check contained exception for details.", e);
        }
    }

    private void checkMail(@Nonnull Mail mail) {
        if (!mail.hasSender()) {
            if (this._defaultSenderAddress == null) {
                throw new IllegalArgumentException("This sender requires a sender's address.");
            }
            mail.withSender(this._defaultSenderAddress, this._defaultPersonal);
        }
    }

    @Nonnull
    private Properties createProperties() {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", this._server.getHostName());
        properties.setProperty("mail.smtp.port", Integer.toString(this._server.getPort()));
        properties.setProperty("mail.smtp.auth", Boolean.toString(this._authentication != null));
        return properties;
    }

    @Nonnull
    private Message toMessage(@Nonnull Mail mail, @Nonnull Session session) {
        MimeMessage message = new MimeMessage(session);
        String body = this.getBodyFrom(mail);
        try {
            message.setFrom((Address)mail.getSender());
            this.setRecipients(mail, (Message)message);
            message.setSubject(mail.getSubject());
            message.setText(body);
        }
        catch (MessagingException e) {
            throw new MailSender.MailSenderException("Could not send message, see enclosed exception.", e);
        }
        return message;
    }

    @Nonnull
    private String getBodyFrom(@Nonnull Mail mail) {
        String body = mail.getBody().get(ImmutableMimeType.TEXT_PLAIN);
        if (body == null && (body = mail.getBody().get(ImmutableMimeType.TEXT_HTML)) == null) {
            body = mail.getBody().get(ImmutableMimeType.APPLICATION_OCTET_STREAM);
        }
        if (body == null) {
            body = "";
        }
        return body;
    }

    private void setRecipients(@Nonnull Mail mail, @Nonnull Message message) throws MessagingException {
        message.setRecipients(Message.RecipientType.TO, this.convertToAddressArray(mail.getRecipients().get(Message.RecipientType.TO)));
        message.setRecipients(Message.RecipientType.CC, this.convertToAddressArray(mail.getRecipients().get(Message.RecipientType.CC)));
        message.setRecipients(Message.RecipientType.BCC, this.convertToAddressArray(mail.getRecipients().get(Message.RecipientType.BCC)));
    }

    @Nullable
    private Address[] convertToAddressArray(@Nullable List<InternetAddress> addresses) {
        Address[] addressArray;
        if (addresses == null) {
            addressArray = null;
        } else {
            addressArray = new Address[addresses.size()];
            for (int i = 0; i < addressArray.length; ++i) {
                addressArray[i] = (Address)addresses.get(i);
            }
        }
        return addressArray;
    }

    public class Authentication
    extends Authenticator {
        private final String _user;
        private final String _password;

        public Authentication(@Nonnull String user, String password) {
            this._user = user;
            this._password = password;
        }

        @Nonnull
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this._user, this._password);
        }
    }
}

