/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.ResourceTypeProvider;

@ThreadSafe
public class DefaultResourceTypeProvider
implements ResourceTypeProvider {
    private final Map<String, ResourceType> _nameToResourceType = new HashMap<String, ResourceType>();
    private final Map<String, ResourceType> _contentTypeToResourceType = new HashMap<String, ResourceType>();

    public DefaultResourceTypeProvider() {
        this(null);
    }

    public DefaultResourceTypeProvider(@Nullable Set<ResourceType> resourceTypeExtensions) {
        for (ResourceType resourceType : ResourceType.getSystemTypes()) {
            if (!this._nameToResourceType.containsKey(resourceType.getName())) {
                this._nameToResourceType.put(resourceType.getName(), resourceType);
            }
            if (this._contentTypeToResourceType.containsKey(resourceType.getContentType())) continue;
            this._contentTypeToResourceType.put(resourceType.getContentType(), resourceType);
        }
        if (resourceTypeExtensions != null) {
            for (ResourceType resourceType : resourceTypeExtensions) {
                if (!this._nameToResourceType.containsKey(resourceType.getName())) {
                    this._nameToResourceType.put(resourceType.getName(), resourceType);
                }
                if (this._contentTypeToResourceType.containsKey(resourceType.getContentType())) continue;
                this._contentTypeToResourceType.put(resourceType.getContentType(), resourceType);
            }
        }
    }

    @Override
    @Nonnull
    public ResourceType getBy(@Nonnull String name) throws IllegalArgumentException {
        ResourceType resourceType = this._nameToResourceType.get(name);
        if (resourceType == null) {
            throw new IllegalArgumentException("There is no type named: " + name);
        }
        return resourceType;
    }

    @Override
    public ResourceType findByContentType(@Nonnull String contentType) {
        return this._contentTypeToResourceType.get(contentType);
    }

    @Override
    public Iterator<ResourceType> iterator() {
        return Sets.newHashSet(this._nameToResourceType.values()).iterator();
    }
}

