/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.FileResource;
import org.echocat.jomon.resources.PropertiesEnabledResource;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceRepository;
import org.echocat.jomon.resources.ResourceType;

public class FileBasedResourceRepository
implements ResourceRepository<PropertiesEnabledResource<String>> {
    private static final File DEFAULT_BASE_DIRECTORY = new File(System.getProperty("java.io.tmpdir", "." + File.separator + "tmp"), FileBasedResourceRepository.class.getPackage().getName().replace('.', File.separatorChar));
    private volatile File _baseDirectory = DEFAULT_BASE_DIRECTORY;

    @Nonnull
    public File getBaseDirectory() {
        return this._baseDirectory;
    }

    public void setBaseDirectory(@Nonnull File baseDirectory) {
        this._baseDirectory = baseDirectory;
    }

    @Override
    public void save(@Nonnull Resource resource) throws Exception {
        File targetFile = this.createTargetFileFor(resource);
        if (!(this.targetFileIsTheSame(resource, targetFile) || targetFile.isFile() && targetFile.length() == resource.getSize())) {
            FileUtils.forceMkdir((File)targetFile.getParentFile());
            try (InputStream inputStream = resource.openInputStream();
                 FileOutputStream outputStream = new FileOutputStream(targetFile);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            resource.release();
        }
    }

    protected boolean targetFileIsTheSame(@Nonnull Resource resource, @Nonnull File targetFile) throws IOException {
        boolean result = resource instanceof FileResource ? ((FileResource)resource).getFile().getCanonicalFile().equals(targetFile.getCanonicalFile()) : false;
        return result;
    }

    @Override
    @Nullable
    public PropertiesEnabledResource<String> findResourceBy(@Nonnull byte[] md5, @Nonnegative long size, @Nonnull ResourceType type) {
        File targetFile = this.createTargetFileFor(md5, size, type);
        FileResource result = targetFile.isFile() ? new FileResource(targetFile, md5, type, false) : null;
        return result;
    }

    @Nonnull
    protected File createTargetFileFor(@Nonnull Resource resource) {
        try {
            return this.createTargetFileFor(resource.getMd5(), resource.getSize(), resource.getType());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get target file of " + resource + ".", e);
        }
    }

    @Nonnull
    protected File createTargetFileFor(@Nonnull byte[] md5, @Nonnegative long size, @Nonnull ResourceType type) {
        String md5AsHex = Hex.encodeHexString((byte[])md5);
        StringBuilder sb = new StringBuilder();
        sb.append(md5AsHex.charAt(0)).append(File.separatorChar);
        sb.append(md5AsHex.charAt(1)).append(File.separatorChar);
        sb.append(md5AsHex.charAt(2)).append(File.separatorChar);
        sb.append(md5AsHex.charAt(3)).append(File.separatorChar);
        sb.append(md5AsHex).append('_').append(size).append('.').append(type);
        return new File(this._baseDirectory, sb.toString());
    }
}

