/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.LoggingEnabledResource;
import org.echocat.jomon.resources.PrivateUrlEnabledResource;
import org.echocat.jomon.resources.PropertiesEnabledResource;
import org.echocat.jomon.resources.ResourceSupport;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.runtime.codec.Md5Utils;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.iterators.IteratorUtils;
import org.echocat.jomon.runtime.util.Entry;

@ThreadSafe
public class FileResource
extends ResourceSupport
implements PropertiesEnabledResource<String>,
LoggingEnabledResource,
PrivateUrlEnabledResource {
    private final File _file;
    private final ResourceType _type;
    private final boolean _generated;
    private volatile byte[] _md5;
    private Properties _properties;

    public FileResource(@Nonnull File file, @Nonnull ResourceType type, boolean generated) {
        this(file, null, type, generated);
    }

    public FileResource(@Nonnull File file, @Nullable byte[] md5, @Nonnull ResourceType type, boolean generated) {
        this._file = file;
        this._md5 = md5;
        this._type = type;
        this._generated = generated;
    }

    @Override
    @Nonnull
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    @Nonnull
    public ResourceType getType() {
        return this._type;
    }

    @Override
    @Nonnull
    public byte[] getMd5() throws IOException {
        if (this._md5 == null) {
            this._md5 = Md5Utils.md5Of((File)this._file).asBytes();
        }
        return this._md5;
    }

    @Override
    public long getSize() {
        return this._file.length();
    }

    @Override
    public Date getLastModified() {
        return new Date(this._file.lastModified());
    }

    @Override
    public boolean isExisting() throws IOException {
        return this._file.isFile();
    }

    @Override
    public void release() throws IOException {
        if (this._generated) {
            this._file.delete();
            this.getPropertiesFile().delete();
        }
    }

    @Nonnull
    public File getPropertiesFile() {
        return new File(this._file.getPath() + ".properties");
    }

    @Nonnull
    protected Properties getPropertiesInternal() throws IOException {
        if (this._properties == null) {
            Properties properties = new Properties();
            File propertiesFile = this.getPropertiesFile();
            if (propertiesFile.isFile()) {
                try (FileInputStream is = new FileInputStream(propertiesFile);
                     InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");){
                    properties.load(reader);
                }
            }
            this._properties = properties;
        }
        return this._properties;
    }

    protected void saveProperties(@Nonnull Properties properties) throws IOException {
        File propertiesFile = this.getPropertiesFile();
        if (properties.isEmpty()) {
            if (propertiesFile.exists() && !propertiesFile.delete()) {
                throw new IOException("Could not delete the old and not longer needed properties file: " + propertiesFile);
            }
        } else {
            FileUtils.forceMkdir((File)propertiesFile.getParentFile());
            try (FileOutputStream os = new FileOutputStream(propertiesFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");){
                properties.store(writer, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Iterable<Entry<String, String>> getProperties() throws IOException {
        HashMap copy;
        FileResource fileResource = this;
        synchronized (fileResource) {
            copy = new HashMap(this.getPropertiesInternal());
        }
        return new Iterable<Entry<String, String>>(){

            @Override
            public Iterator<Entry<String, String>> iterator() {
                return new ConvertingIterator<Map.Entry<String, String>, Entry<String, String>>(copy.entrySet().iterator()){
                    private final AtomicReference<String> _currentKey;
                    {
                        this._currentKey = new AtomicReference();
                    }

                    protected Entry<String, String> convert(Map.Entry<String, String> input) {
                        this._currentKey.set(input.getKey());
                        return new Entry.Impl((Object)input.getKey(), (Object)input.getValue());
                    }

                    public void remove() {
                        String key = this._currentKey.get();
                        if (key != null) {
                            try {
                                FileResource.this.removeProperty(key);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Could not remove " + key + ".", e);
                            }
                        }
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(@Nonnull String name) throws IOException {
        FileResource fileResource = this;
        synchronized (fileResource) {
            return this.getPropertiesInternal().getProperty(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(@Nonnull String name, @Nullable Object value) throws IOException {
        FileResource fileResource = this;
        synchronized (fileResource) {
            Properties properties = this.getPropertiesInternal();
            if (value != null) {
                properties.put(name, value);
            } else {
                properties.remove(name);
            }
            this.saveProperties(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProperty(@Nonnull String name) throws IOException {
        FileResource fileResource = this;
        synchronized (fileResource) {
            Properties properties = this.getPropertiesInternal();
            properties.remove(name);
            this.saveProperties(properties);
        }
    }

    @Override
    @Nonnull
    public Class<String> getPropertyValueType() {
        return String.class;
    }

    @Nonnull
    public File getFile() {
        return this._file;
    }

    @Nonnull
    public File getLoggingFile() {
        return new File(this._file.getPath() + ".log");
    }

    @Override
    public void logMessage(@Nonnull String message) throws IOException {
        try (FileOutputStream os = new FileOutputStream(this.getLoggingFile(), true);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");){
            writer.write(message.replace("\\", "\\\\").replace("\n", "\\n"));
            ((Writer)writer).write(10);
            ((Writer)writer).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public CloseableIterator<String> logMessageIterator() throws IOException {
        CloseableIterator result;
        block13: {
            if (this.getLoggingFile().isFile()) {
                boolean success = false;
                final FileInputStream is = new FileInputStream(this.getLoggingFile());
                try {
                    final InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
                    try {
                        final BufferedReader bufferedReader = new BufferedReader(reader);
                        try {
                            success = true;
                            final String firstLine = this.readNextMessageOf(bufferedReader);
                            result = new CloseableIterator<String>(){
                                private String _line;
                                {
                                    this._line = firstLine;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void close() {
                                    try {
                                        IOUtils.closeQuietly((Reader)bufferedReader);
                                    }
                                    finally {
                                        try {
                                            IOUtils.closeQuietly((Reader)reader);
                                        }
                                        finally {
                                            IOUtils.closeQuietly((InputStream)is);
                                        }
                                    }
                                }

                                public boolean hasNext() {
                                    return this._line != null;
                                }

                                public String next() {
                                    String result = this._line;
                                    if (result == null) {
                                        throw new NoSuchElementException();
                                    }
                                    this._line = FileResource.this.readNextMessageOf(bufferedReader);
                                    return result;
                                }

                                public void remove() {
                                    throw new UnsupportedOperationException();
                                }
                            };
                            break block13;
                        }
                        finally {
                            if (!success) {
                                IOUtils.closeQuietly((Reader)bufferedReader);
                            }
                        }
                    }
                    finally {
                        if (!success) {
                            IOUtils.closeQuietly((Reader)reader);
                        }
                    }
                }
                finally {
                    if (!success) {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
            }
            result = IteratorUtils.emptyCloseableIterator();
        }
        return result;
    }

    @Nullable
    protected String readNextMessageOf(@Nonnull BufferedReader bufferedReader) {
        try {
            String line = bufferedReader.readLine();
            return line != null ? line.replace("\\n", "\n").replace("\\\\", "\\") : null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read next line.", e);
        }
    }

    @Override
    public boolean isGenerated() throws IOException {
        return this._generated;
    }

    @Override
    @Nonnull
    public URL getPrivateUrl() throws IOException {
        return this._file.toURI().toURL();
    }
}

