/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.annotation.Nonnull;
import org.echocat.jomon.resources.PrivateUrlEnabledResource;
import org.echocat.jomon.resources.ResourceSupport;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.UriEnabledResource;

public class UrlResource
extends ResourceSupport
implements UriEnabledResource,
PrivateUrlEnabledResource {
    private final URL _url;
    private final ResourceType _resourceType;
    private final boolean _generated;
    private volatile Long _size;
    private volatile Boolean _exists;
    private volatile Date _lastModified;

    public UrlResource(@Nonnull URL url, @Nonnull ResourceType resourceType, boolean generated) {
        this._url = url;
        this._resourceType = resourceType;
        this._generated = generated;
    }

    @Override
    @Nonnull
    public InputStream openInputStream() throws IOException {
        return this._url.openStream();
    }

    @Override
    @Nonnull
    public ResourceType getType() throws IOException {
        return this._resourceType;
    }

    @Override
    public long getSize() throws IOException {
        this.loadLazyValues();
        return this._size;
    }

    @Override
    public Date getLastModified() throws IOException {
        this.loadLazyValues();
        return this._lastModified;
    }

    @Override
    public boolean isExisting() throws IOException {
        this.loadLazyValues();
        return this._exists;
    }

    @Override
    public boolean isGenerated() throws IOException {
        return this._generated;
    }

    @Override
    @Nonnull
    public String getUri() {
        return this._url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLazyValues() throws IOException {
        if (this._size == null || this._exists == null) {
            try {
                URLConnection urlConnection = this._url.openConnection();
                try {
                    this._size = urlConnection.getContentLengthLong();
                    this._exists = true;
                    long lastModified = urlConnection.getLastModified();
                    this._lastModified = lastModified > 0L ? new Date(lastModified) : null;
                }
                finally {
                    if (urlConnection instanceof HttpURLConnection) {
                        ((HttpURLConnection)urlConnection).disconnect();
                    }
                }
            }
            catch (FileNotFoundException ignored) {
                this._exists = false;
                this._size = 0L;
            }
        }
    }

    @Override
    @Nonnull
    public URL getPrivateUrl() throws IOException {
        return this._url;
    }
}

