/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CacheProvider;
import org.echocat.jomon.cache.management.DefaultCacheDefinition;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.OptimizationContextUtils;
import org.echocat.jomon.resources.optimizing.ResourcesOptimizer;

public abstract class CachedResourcesOptimizer
implements ResourcesOptimizer {
    public static final OptimizationContext.Feature SKIP_CACHE = OptimizationContextUtils.feature(CachedResourcesOptimizer.class, "skipCache");
    private final Cache<CacheKey, Collection<Resource>> _cache;

    protected CachedResourcesOptimizer(@Nonnull CacheProvider cacheProvider) {
        this._cache = cacheProvider.provide(this.getClass(), "resources", (CacheDefinition)DefaultCacheDefinition.lruCache(CacheKey.class, Collection.class).withCapacity(1000L));
    }

    @Override
    @Nonnull
    public Collection<Resource> optimize(@Nonnull Collection<Resource> inputs, @Nonnull OptimizationContext context) throws Exception {
        Collection<Resource> outputs;
        CacheKey cacheKey = new CacheKey(inputs, context.getFeatures());
        Collection<Resource> collection = outputs = !context.isFeatureEnabled(SKIP_CACHE) ? (Collection<Resource>)this._cache.get((Object)cacheKey) : null;
        if (outputs == null || !this.allExists(outputs)) {
            outputs = this.optimizeIfAbsent(inputs, context);
            this._cache.put((Object)cacheKey, outputs);
        }
        return outputs;
    }

    protected boolean allExists(@Nonnull Collection<Resource> outputs) throws IOException {
        boolean allExists = true;
        for (Resource output : outputs) {
            if (output.isExisting()) continue;
            allExists = false;
            break;
        }
        return allExists;
    }

    @Nonnull
    public abstract Collection<Resource> optimizeIfAbsent(@Nonnull Collection<Resource> var1, @Nonnull OptimizationContext var2) throws Exception;

    protected class CacheKey {
        private final Collection<Resource> _resources;
        private final Set<OptimizationContext.Feature> _features;

        public CacheKey(@Nonnull Collection<Resource> resources, Set<OptimizationContext.Feature> features) {
            this._resources = resources;
            this._features = features;
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof CacheKey)) {
                result = false;
            } else {
                CacheKey that = (CacheKey)o;
                result = this._features.equals(that._features) && this._resources.equals(that._resources);
            }
            return result;
        }

        public int hashCode() {
            int result = this._resources.hashCode();
            result = 31 * result + this._features.hashCode();
            return result;
        }
    }
}

