/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.MemoryResourceGenerator;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.OptimizationContextUtils;
import org.echocat.jomon.resources.optimizing.ResourcesOptimizer;

public class CombineJavaScriptResourcesOptimizer
implements ResourcesOptimizer {
    public static final OptimizationContext.Feature SKIP_JAVA_SCRIPT_COMBINATION = OptimizationContextUtils.feature(ResourcesOptimizer.class, "skipJavaScriptCombination");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Collection<Resource> optimize(@Nonnull Collection<Resource> inputs, @Nonnull OptimizationContext context) throws Exception {
        ArrayList<Resource> outputs = new ArrayList<Resource>();
        try (MemoryResourceGenerator generator = new MemoryResourceGenerator(ResourceType.js, "/combined/");){
            boolean jsWritten = false;
            for (Resource input : inputs) {
                if (ResourceType.js.equals(input.getType()) && !context.isFeatureEnabled(SKIP_JAVA_SCRIPT_COMBINATION)) {
                    jsWritten = true;
                    try {
                        InputStream inputStream = input.openInputStream();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(inputStream);
                            Throwable throwable2 = null;
                            try {
                                String content = IOUtils.toString((Reader)reader);
                                OutputStreamWriter writer = new OutputStreamWriter(generator);
                                Throwable throwable3 = null;
                                try {
                                    writer.write(content);
                                    writer.write("\n");
                                    continue;
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (writer == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            ((Writer)writer).close();
                                        }
                                        catch (Throwable x2) {
                                            throwable3.addSuppressed(x2);
                                        }
                                        continue;
                                    }
                                    ((Writer)writer).close();
                                    continue;
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                                continue;
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            inputStream.close();
                            continue;
                        }
                    }
                    finally {
                        input.release();
                        continue;
                    }
                }
                outputs.add(input);
            }
            if (jsWritten) {
                outputs.add(generator.getTemporaryBufferedResource());
            } else {
                generator.drop();
            }
        }
        return outputs;
    }

    @Override
    public boolean isSupporting(@Nonnull ResourceType type) {
        return ResourceType.js.equals(type);
    }

    @Override
    @Nonnull
    public Set<ResourceType> getSupportedResourceTypes() {
        return Collections.singleton(ResourceType.js);
    }
}

