/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing.yui;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.echocat.jomon.resources.optimizing.yui.YuiClassLoaderFactory;

public abstract class FacadeSupport {
    protected static final ClassLoader CLASS_LOADER = YuiClassLoaderFactory.getClassLoader();

    @Nonnull
    protected static Class<?> loadClass(@Nonnull String className, @Nonnull ClassLoader from) {
        try {
            return from.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Nonnull
    protected static Constructor<?> loadConstructor(@Nonnull Class<?> type, Class<?> ... arguments) {
        try {
            return type.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Nonnull
    protected static Method loadMethod(@Nonnull Class<?> type, @Nonnull String name, Class<?> ... arguments) {
        try {
            return type.getMethod(name, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

