/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing.yui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public class YuiClassLoaderFactory {
    private static final ClassLoader CLASS_LOADER = YuiClassLoaderFactory.createClassLoader();

    @Nonnull
    public static ClassLoader getClassLoader() {
        return CLASS_LOADER;
    }

    @Nonnull
    private static ClassLoader createClassLoader() {
        return new URLClassLoader(new URL[]{YuiClassLoaderFactory.createUrlCopyOf("js-1.7R2.jar"), YuiClassLoaderFactory.createUrlCopyOf("slf4j-api-1.5.6.jar"), YuiClassLoaderFactory.createUrlCopyOf("slf4j-jdk14-1.5.6.jar"), YuiClassLoaderFactory.createUrlCopyOf("servlet-api-2.5.jar"), YuiClassLoaderFactory.createUrlCopyOf("wro4j-core-1.4.5.jar"), YuiClassLoaderFactory.createUrlCopyOf("wro4j-extensions-1.4.5.jar")}, null);
    }

    @Nonnull
    private static URL createUrlCopyOf(@Nonnull String fileName) {
        try {
            File file = YuiClassLoaderFactory.getFileFor(fileName);
            try (InputStream is = YuiClassLoaderFactory.class.getResourceAsStream(fileName);){
                if (is == null) {
                    throw new IllegalArgumentException("Could not find resource named: " + fileName);
                }
                try (FileOutputStream os = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            return file.toURI().toURL();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create url copy of " + fileName + ".", e);
        }
    }

    @Nonnull
    private static File getFileFor(@Nonnull String fileName) {
        File directory = YuiClassLoaderFactory.getDirectory();
        directory.mkdirs();
        return new File(directory, fileName);
    }

    @Nonnull
    private static File getDirectory() {
        return new File(System.getProperty("java.io.tmdir", "tmp"), "yuicache");
    }

    private YuiClassLoaderFactory() {
    }
}

