/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.echocat.jomon.net.http.HttpResponseException;
import org.echocat.jomon.runtime.CollectionUtils;

public class HttpUtils {
    private static final HttpClient CLIENT = new DefaultHttpClient();

    @Nonnull
    public static Reader makeGetRequestAndReturnBodyReaderFor(@Nonnull URL url) throws IOException {
        HttpResponse response = HttpUtils.makeGetRequestAndReturnResponseFor(url);
        return HttpUtils.toReader(response);
    }

    @Nonnull
    public static Reader toReader(@Nonnull HttpResponse response) throws IOException {
        if (HttpUtils.wasResponseSuccessful(response)) {
            return HttpUtils.createBodyReaderFor(response.getEntity());
        }
        throw HttpUtils.makeIoExceptionFrom(response);
    }

    @Nonnull
    public static InputStream toInputStream(@Nonnull HttpResponse response) throws IOException {
        if (HttpUtils.wasResponseSuccessful(response)) {
            return HttpUtils.createBodyInputStreamFor(response.getEntity());
        }
        throw HttpUtils.makeIoExceptionFrom(response);
    }

    @Nonnull
    public static String toString(@Nonnull HttpResponse response) throws IOException {
        try (Reader reader = HttpUtils.toReader(response);){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    @Nonnull
    public static String makeGetRequestAndReturnBodyAsStringFor(@Nonnull URL url) throws IOException {
        try (Reader reader = HttpUtils.makeGetRequestAndReturnBodyReaderFor(url);){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    @Nonnull
    public static HttpResponse makeGetRequestAndReturnResponseFor(@Nonnull URL url) throws IOException {
        HttpGet httpUriRequest = new HttpGet(url.toExternalForm());
        return CLIENT.execute((HttpUriRequest)httpUriRequest);
    }

    @Nonnull
    public static HttpGet makeGetRequestFor(@Nonnull URL url) throws IOException {
        return new HttpGet(url.toExternalForm());
    }

    public static boolean wasResponseSuccessful(@Nonnull HttpResponse response) {
        int statusCode;
        StatusLine statusLine = response.getStatusLine();
        boolean result = statusLine != null ? (statusCode = statusLine.getStatusCode()) < 400 : false;
        return result;
    }

    @Nonnull
    public static HttpResponseException makeIoExceptionFrom(@Nonnull HttpResponse response) throws IOException {
        String body;
        String statusMessage;
        int statusCode;
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            statusCode = statusLine.getStatusCode();
            statusMessage = statusLine.getReasonPhrase();
        } else {
            statusCode = 0;
            statusMessage = null;
        }
        try (Reader bodyReader = HttpUtils.createBodyReaderFor(response.getEntity());){
            body = IOUtils.toString((Reader)bodyReader);
        }
        return new HttpResponseException(statusCode, statusMessage, body);
    }

    @Nonnull
    public static Reader createBodyReaderFor(@Nonnull HttpEntity entity) throws IOException {
        Charset charset = HttpUtils.findCharSetOf(entity);
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        return new InputStreamReader(entity.getContent(), charset);
    }

    @Nonnull
    public static InputStream createBodyInputStreamFor(@Nonnull HttpEntity entity) throws IOException {
        return entity.getContent();
    }

    @Nullable
    public static Charset findCharSetOf(@Nonnull HttpEntity entity) throws IOException {
        MimeType mimeType = HttpUtils.findMimeTypeOf(entity);
        return HttpUtils.findCharSetOf(mimeType);
    }

    @Nullable
    public static Charset findCharSetOf(@Nullable MimeType mimeType) throws IOException {
        String charsetName = mimeType != null ? mimeType.getParameter("charset") : null;
        try {
            return charsetName != null ? Charset.forName(charsetName) : null;
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException("In contentType '" + mimeType + "' was an unsupported charset provided.", e);
        }
    }

    @Nullable
    public static MimeType findMimeTypeOf(@Nonnull HttpEntity entity) throws IOException {
        MimeType mimeType;
        Header contentTypeHeader = entity.getContentType();
        String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : null;
        try {
            mimeType = contentType != null ? new MimeType(contentType) : null;
        }
        catch (MimeTypeParseException e) {
            throw new IOException("Illegal contentType: " + contentType, e);
        }
        return mimeType;
    }

    @Nonnull
    public static String urlDecode(@Nonnull String encodedString) {
        try {
            return URLDecoder.decode(encodedString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Nonnull
    public static String encodeUrl(@Nonnull String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported.", e);
        }
    }

    @Nonnull
    public static HttpPost postFor(@Nonnull URI uri, @Nonnull Charset charset, String ... parameters) throws UnsupportedEncodingException {
        return HttpUtils.postFor(uri, charset, parameters != null ? CollectionUtils.asMap((Object[])parameters) : null);
    }

    @Nonnull
    public static HttpPost postFor(@Nonnull URI uri, @Nonnull Charset charset, @Nullable Map<String, String> parameters) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(uri);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(parameters != null ? parameters.size() : 0);
        if (parameters != null) {
            for (Map.Entry<String, String> keyToValue : parameters.entrySet()) {
                pairs.add(new BasicNameValuePair(keyToValue.getKey(), keyToValue.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
        return httpPost;
    }

    @Nonnull
    public static HttpGet getFor(@Nonnull URI uri, @Nonnull Charset charset, String ... parameters) throws UnsupportedEncodingException {
        return HttpUtils.getFor(uri, charset, parameters != null ? CollectionUtils.asMap((Object[])parameters) : null);
    }

    @Nonnull
    public static HttpGet getFor(@Nonnull URI uri, @Nonnull Charset charset, @Nullable Map<String, String> parameters) throws UnsupportedEncodingException {
        HttpGet httpGet;
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(uri);
            boolean questionMarkAdded = uri.getQuery() != null;
            for (Map.Entry<String, String> keyToValue : parameters.entrySet()) {
                if (questionMarkAdded) {
                    sb.append('&');
                } else {
                    sb.append('?');
                    questionMarkAdded = true;
                }
                sb.append(URLEncoder.encode(keyToValue.getKey(), charset.name())).append('=').append(URLEncoder.encode(keyToValue.getValue(), charset.name()));
            }
            httpGet = new HttpGet(URI.create(sb.toString()));
        } else {
            httpGet = new HttpGet(uri);
        }
        return httpGet;
    }

    private HttpUtils() {
    }
}

