/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.NegotiateScheme;
import org.echocat.jomon.net.http.client.HttpClientUtils;

public class HttpClientAuth {
    protected static final Pattern PLAIN_PARSE_PATTERN = Pattern.compile("([a-zA-Z0-9]+:\\/\\/[^&]+)&([^&]*)&([^&]*)(?:&(.*)|)");
    private final AuthScope _scope;
    private final HttpHost _host;
    private final Credentials _credentials;
    private final AuthScheme _scheme;

    public HttpClientAuth(@Nonnull String asString) {
        Matcher matcher = PLAIN_PARSE_PATTERN.matcher(asString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse: " + asString);
        }
        this._host = this.parseAuthHostOf(matcher);
        this._scope = HttpClientUtils.toAuthScope(this._host);
        this._credentials = this.parseCredentialsOf(matcher);
        this._scheme = this.parseSchemeOf(matcher);
    }

    @Nonnull
    protected HttpHost parseAuthHostOf(@Nonnull Matcher matcher) {
        try {
            URI uri = new URI(matcher.group(1));
            return HttpClientUtils.toHttpHost(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not parse uri part of: " + matcher.group(), e);
        }
    }

    @Nonnull
    protected Credentials parseCredentialsOf(@Nonnull Matcher matcher) {
        return new UsernamePasswordCredentials(matcher.group(2), matcher.group(3));
    }

    @Nonnull
    protected AuthScheme parseSchemeOf(@Nonnull Matcher matcher) {
        DigestScheme authScheme;
        String plainAuthScheme = matcher.group(4);
        if ("digest".equalsIgnoreCase(plainAuthScheme)) {
            authScheme = new DigestScheme();
        } else if ("negotiate".equalsIgnoreCase(plainAuthScheme)) {
            authScheme = new NegotiateScheme();
        } else if ("basic".equalsIgnoreCase(plainAuthScheme) || StringUtils.isEmpty((CharSequence)plainAuthScheme)) {
            authScheme = new BasicScheme();
        } else {
            throw new IllegalArgumentException("Unknown authScheme '" + plainAuthScheme + "' of: " + matcher.group());
        }
        return authScheme;
    }

    public HttpClientAuth(@Nonnull URI host, @Nonnull String username, @Nonnull String password) {
        this(host, (Credentials)new UsernamePasswordCredentials(username, password), (AuthScheme)new BasicScheme());
    }

    public HttpClientAuth(@Nonnull URI host, @Nonnull Credentials credentials) {
        this(host, credentials, (AuthScheme)new BasicScheme());
    }

    public HttpClientAuth(@Nonnull HttpHost host, @Nonnull String username, @Nonnull String password) {
        this(host, (Credentials)new UsernamePasswordCredentials(username, password), (AuthScheme)new BasicScheme());
    }

    public HttpClientAuth(@Nonnull HttpHost host, @Nonnull Credentials credentials) {
        this(host, credentials, (AuthScheme)new BasicScheme());
    }

    public HttpClientAuth(@Nonnull AuthScope scope, @Nonnull HttpHost host, @Nonnull String username, @Nonnull String password) {
        this(scope, host, (Credentials)new UsernamePasswordCredentials(username, password), (AuthScheme)new BasicScheme());
    }

    public HttpClientAuth(@Nonnull AuthScope scope, @Nonnull HttpHost host, @Nonnull Credentials credentials) {
        this(scope, host, credentials, (AuthScheme)new BasicScheme());
    }

    public HttpClientAuth(@Nonnull URI host, @Nonnull String username, @Nonnull String password, @Nonnull AuthScheme scheme) {
        this(HttpClientUtils.toHttpHost(host), (Credentials)new UsernamePasswordCredentials(username, password), scheme);
    }

    public HttpClientAuth(@Nonnull URI host, @Nonnull Credentials credentials, @Nonnull AuthScheme scheme) {
        this(HttpClientUtils.toHttpHost(host), credentials, scheme);
    }

    public HttpClientAuth(@Nonnull HttpHost host, @Nonnull String username, @Nonnull String password, @Nonnull AuthScheme scheme) {
        this(host, (Credentials)new UsernamePasswordCredentials(username, password), scheme);
    }

    public HttpClientAuth(@Nonnull HttpHost host, @Nonnull Credentials credentials, @Nonnull AuthScheme scheme) {
        this(HttpClientUtils.toAuthScope(host), host, credentials, scheme);
    }

    public HttpClientAuth(@Nonnull AuthScope scope, @Nonnull HttpHost host, @Nonnull String username, @Nonnull String password, @Nonnull AuthScheme scheme) {
        this(scope, host, (Credentials)new UsernamePasswordCredentials(username, password), scheme);
    }

    public HttpClientAuth(@Nonnull AuthScope scope, @Nonnull HttpHost host, @Nonnull Credentials credentials, @Nonnull AuthScheme scheme) {
        this._scope = scope;
        this._host = host;
        this._credentials = credentials;
        this._scheme = scheme;
    }

    @Nonnull
    public AuthScope getScope() {
        return this._scope;
    }

    @Nonnull
    public HttpHost getHost() {
        return this._host;
    }

    @Nonnull
    public URI toUri() {
        return URI.create(this.getHost().toURI());
    }

    @Nonnull
    public Credentials getCredentials() {
        return this._credentials;
    }

    @Nonnull
    public AuthScheme getScheme() {
        return this._scheme;
    }
}

