/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.net.Protocol;
import org.echocat.jomon.net.cluster.channel.ByteUtils;
import org.echocat.jomon.net.cluster.channel.Message;
import org.echocat.jomon.net.cluster.channel.tcp.OutboundTcpNode;
import org.echocat.jomon.net.service.SrvEntryBasedServicesManager;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.jomon.runtime.util.ServiceTemporaryUnavailableException;

@ThreadSafe
public class OutboundTcpHandler
extends SrvEntryBasedServicesManager<InetSocketAddress, OutboundTcpNode> {
    private final Map<InetSocketAddress, OutboundTcpNode> _addressToNode = new WeakHashMap<InetSocketAddress, OutboundTcpNode>();
    private final Map<OutboundTcpNode, Sender> _nodeToSender = new ConcurrentHashMap<OutboundTcpNode, Sender>();
    private final UUID _uuid;
    private final boolean _dropMessagesIfQueueIsFull;
    private final int _queuePerNodeCapacity;
    private final String _name;
    private final boolean _waitForSendFinished;
    private Duration _connectionTimeout = new Duration("2s");
    private Duration _soTimeout = new Duration("30s");

    public OutboundTcpHandler(@Nonnull String service, @Nonnull UUID uuid, @Nonnegative int queuePerNodeCapacity, @Nullable String name, boolean waitForSendFinished, boolean dropMessagesIfQueueIsFull) {
        super(Protocol.tcp, service);
        this._uuid = uuid;
        this._dropMessagesIfQueueIsFull = dropMessagesIfQueueIsFull;
        this._queuePerNodeCapacity = queuePerNodeCapacity > 0 ? queuePerNodeCapacity : 1;
        this._name = name;
        this._waitForSendFinished = waitForSendFinished;
        this.setCheckerThreadName(this.toString() + ".Checker");
    }

    @Nonnull
    public Duration getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(@Nonnull Duration connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    @Nonnull
    public Duration getSoTimeout() {
        return this._soTimeout;
    }

    public void setSoTimeout(@Nonnull Duration soTimeout) {
        this._soTimeout = soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutboundTcpNode tryGetOutputFor(@Nonnull InetSocketAddress original, @Nonnull InetSocketAddress target, @Nonnull SrvEntryBasedServicesManager.State oldState) throws Exception {
        OutboundTcpHandler outboundTcpHandler = this;
        synchronized (outboundTcpHandler) {
            OutboundTcpNode node = this._addressToNode.get(target);
            if (node == null || !node.isConnected()) {
                node = this.createNewNodeFor(target);
                this._addressToNode.put(target, node);
            }
            if (node != null) {
                boolean success = false;
                try {
                    this.sendUnsafe(this.createPingMessage(), node);
                    success = true;
                }
                finally {
                    if (!success) {
                        ResourceUtils.closeQuietly((Object)node);
                        node = null;
                    }
                }
            }
            return node;
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    protected OutboundTcpNode createNewNodeFor(@Nonnull InetSocketAddress target) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    protected UUID readUuid(@Nonnull InputStream is) throws IOException {
        byte[] buf = new byte[16];
        int read = is.read(buf);
        if (read != 16) {
            throw new IOException("Received a content that is not 16 bytes long.");
        }
        return new UUID(ByteUtils.getLong(buf, 0), ByteUtils.getLong(buf, 8));
    }

    protected void sendUuid(@Nonnull OutputStream to, @Nonnull UUID localUuid) throws IOException {
        byte[] uuidAsBytes = new byte[16];
        ByteUtils.putLong(uuidAsBytes, 0, localUuid.getMostSignificantBits());
        ByteUtils.putLong(uuidAsBytes, 8, localUuid.getLeastSignificantBits());
        to.write(uuidAsBytes);
    }

    public void send(@Nonnull Message message) throws IOException, InterruptedException {
        Object[] outputs = this.getOutputs();
        HashSet<SendingTask> tasks = this._waitForSendFinished ? new HashSet<SendingTask>(outputs.length) : null;
        for (Object output : outputs) {
            SendingTask task;
            Sender sender = this._nodeToSender.get(output);
            if (sender == null || (task = sender.submit(message)) == null || tasks == null) continue;
            tasks.add(task);
        }
        if (tasks != null) {
            for (SendingTask task : tasks) {
                try {
                    task.get();
                }
                catch (ExecutionException e) {
                    this.handleExecutionException(e);
                }
            }
        }
    }

    public void send(@Nonnull Message message, @Nonnegative long timeout, @Nonnull TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        long timeoutAtInMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        Object[] outputs = this.getOutputs();
        HashSet<SendingTask> tasks = this._waitForSendFinished ? new HashSet<SendingTask>(outputs.length) : null;
        for (Object output : outputs) {
            Sender sender = this._nodeToSender.get(output);
            if (sender == null) continue;
            long currentTimeoutInMillis = timeoutAtInMillis - System.currentTimeMillis();
            if (currentTimeoutInMillis > 0L) {
                SendingTask task = sender.submit(message, currentTimeoutInMillis, TimeUnit.MILLISECONDS);
                if (task == null || tasks == null) continue;
                tasks.add(task);
                continue;
            }
            throw new TimeoutException();
        }
        if (tasks != null) {
            for (SendingTask task : tasks) {
                long currentTimeoutInMillis = timeoutAtInMillis - System.currentTimeMillis();
                if (currentTimeoutInMillis > 0L) {
                    try {
                        task.get(currentTimeoutInMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        this.handleExecutionException(e);
                    }
                    continue;
                }
                throw new TimeoutException();
            }
        }
    }

    protected void handleExecutionException(@Nonnull ExecutionException e) throws IOException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause != null) {
            throw new RuntimeException(cause.getMessage(), cause);
        }
        throw new RuntimeException(e);
    }

    public void sendPing() {
        try {
            this.check();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new RuntimeException("It was not possible to send a ping to all nodes.", e);
        }
    }

    @Nonnull
    public Object[] getOutputs() {
        return super.getOutputs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(@Nonnull Message message, @Nonnull OutboundTcpNode to) throws IOException, InterruptedException {
        boolean success = false;
        boolean errorHandled = false;
        try {
            this.sendUnsafe(message, to);
            success = true;
        }
        catch (ServiceTemporaryUnavailableException e) {
            this.markAsGone(to, e.getMessage());
            errorHandled = true;
        }
        finally {
            if (!success && !errorHandled) {
                this.markAsGone(to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUnsafe(@Nonnull Message message, @Nonnull OutboundTcpNode to) throws IOException {
        OutboundTcpNode outboundTcpNode = to;
        synchronized (outboundTcpNode) {
            try {
                OutputStream os = to.getOutputStream();
                os.write(message.getCommand());
                byte[] lengthAsBytes = new byte[4];
                ByteUtils.putInt(lengthAsBytes, 0, message.getLength());
                os.write(lengthAsBytes);
                os.write(message.getData(), message.getOffset(), message.getLength());
                to.recordOutbound();
            }
            catch (SocketException e) {
                throw new ServiceTemporaryUnavailableException((Throwable)e);
            }
        }
    }

    @Nonnull
    protected Message createPingMessage() {
        return new Message(-128, new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsGone(@Nonnull OutboundTcpNode node, @Nullable String cause) throws InterruptedException {
        try {
            super.markAsGone((Object)node, cause);
        }
        finally {
            ResourceUtils.closeQuietly((Object)node);
        }
    }

    @Nonnull
    protected Object[] rebuildOutputs(@Nonnull SrvEntryBasedServicesManager.Containers<OutboundTcpNode> containers) {
        List newContainers = containers.getContainersByLowersPriority();
        Object[] outputs = new Object[newContainers.size()];
        int c = 0;
        for (SrvEntryBasedServicesManager.Container container : newContainers) {
            outputs[c++] = container.getOutput();
        }
        return outputs;
    }

    protected InetSocketAddress toInetSocketAddress(@Nonnull InetSocketAddress input) throws Exception {
        return input;
    }

    protected void reportNoServicesAvailable() {
    }

    public String toString() {
        return "OutboundTcp(" + this.getService() + "/" + (this._name != null ? this._name : this._uuid) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onContainerGone(@Nonnull SrvEntryBasedServicesManager.Container<OutboundTcpNode> container) {
        try {
            Sender sender = this._nodeToSender.remove(container.getOutput());
            ThreadUtils.stop((Thread)sender);
        }
        finally {
            super.onContainerGone(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onContainerEnter(@Nonnull SrvEntryBasedServicesManager.Container<OutboundTcpNode> container) {
        try {
            Sender sender = new Sender((OutboundTcpNode)container.getOutput());
            sender.start();
            this._nodeToSender.put((OutboundTcpNode)container.getOutput(), sender);
        }
        finally {
            super.onContainerEnter(container);
        }
    }

    @Nonnegative
    @Nullable
    public Integer getCurrentMaximumQueueSize() {
        Object[] outputs;
        Integer currentMaximumQueueSize = null;
        for (Object output : outputs = this.getOutputs()) {
            Integer size;
            Sender sender = this._nodeToSender.get(output);
            if (sender == null || (size = sender.getQueueSize()) == null || currentMaximumQueueSize != null && currentMaximumQueueSize >= size) continue;
            currentMaximumQueueSize = size;
        }
        return currentMaximumQueueSize;
    }

    protected class SendingTask
    implements Future<Void> {
        private final Message _message;
        private final OutboundTcpNode _to;
        private final Lock _lock = new ReentrantLock(true);
        private final Condition _condition = this._lock.newCondition();
        private volatile boolean _done;
        private Throwable _exception;

        public SendingTask(@Nonnull Message message, OutboundTcpNode to) {
            this._message = message;
            this._to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws InterruptedException {
            block9: {
                this._lock.lockInterruptibly();
                try {
                    if (this._done) break block9;
                    try {
                        OutboundTcpHandler.this.send(this._message, this._to);
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        this._exception = e;
                    }
                    finally {
                        this._done = true;
                        this._condition.signalAll();
                    }
                }
                finally {
                    this._lock.unlock();
                }
            }
        }

        @Override
        public boolean isDone() {
            return this._done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Void get() throws InterruptedException, ExecutionException {
            this._lock.lockInterruptibly();
            try {
                if (!this._done) {
                    this._condition.await();
                }
                if (this._exception != null) {
                    throw new ExecutionException(this._exception);
                }
            }
            finally {
                this._lock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long timeoutInMillis = System.currentTimeMillis() + unit.toMillis(timeout);
            long lockTimeout = timeoutInMillis - System.currentTimeMillis();
            if (lockTimeout > 0L && !this._lock.tryLock(lockTimeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
            try {
                long awaitTimeout;
                if (!this._done && (awaitTimeout = timeoutInMillis - System.currentTimeMillis()) > 0L && !this._condition.await(awaitTimeout, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException();
                }
                if (this._exception != null) {
                    throw new ExecutionException(this._exception);
                }
                if (!this._done) {
                    throw new TimeoutException();
                }
            }
            finally {
                this._lock.unlock();
            }
            return null;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    protected class Sender
    extends Thread {
        private final OutboundTcpNode _node;
        private final BlockingDeque<SendingTask> _tasks;

        public Sender(OutboundTcpNode node) {
            this._node = node;
            this._tasks = new LinkedBlockingDeque<SendingTask>(OutboundTcpHandler.this._queuePerNodeCapacity);
            this.setName(this.toString());
        }

        @Override
        public void run() {
            try {
                while (!Sender.currentThread().isInterrupted()) {
                    SendingTask task = this._tasks.take();
                    task.execute();
                }
            }
            catch (InterruptedException ignored) {
                Sender.currentThread().interrupt();
            }
        }

        @Nonnull
        public SendingTask submit(@Nonnull Message message) throws InterruptedException {
            boolean isInQueue;
            SendingTask task = new SendingTask(message, this._node);
            if (OutboundTcpHandler.this._dropMessagesIfQueueIsFull) {
                isInQueue = this._tasks.offer(task);
            } else {
                this._tasks.put(task);
                isInQueue = true;
            }
            return isInQueue ? task : null;
        }

        @Nonnull
        public SendingTask submit(@Nonnull Message message, @Nonnegative long timeout, @Nonnull TimeUnit unit) throws InterruptedException, TimeoutException, IOException {
            SendingTask task = new SendingTask(message, this._node);
            boolean isInQueue = this._tasks.offer(task, timeout, unit);
            if (isInQueue && !OutboundTcpHandler.this._dropMessagesIfQueueIsFull) {
                throw new TimeoutException();
            }
            return isInQueue ? task : null;
        }

        @Nonnegative
        public Integer getQueueSize() {
            return this._tasks.size();
        }

        @Override
        public String toString() {
            return OutboundTcpHandler.this.toString() + ">(" + this._node.getAddress() + ")";
        }
    }
}

