/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.net.cluster.channel.AddressEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.BlockableClusterChannel;
import org.echocat.jomon.net.cluster.channel.DropMessagesEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.Message;
import org.echocat.jomon.net.cluster.channel.NetBasedClusterChannel;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.net.cluster.channel.ReceivedMessage;
import org.echocat.jomon.net.cluster.channel.RemoteAddressesEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.SendingQueueEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.ServiceEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.tcp.InboundTcpNode;
import org.echocat.jomon.net.cluster.channel.tcp.InboundTcpWorker;
import org.echocat.jomon.net.cluster.channel.tcp.LocalTcpNode;
import org.echocat.jomon.net.cluster.channel.tcp.OutboundTcpHandler;
import org.echocat.jomon.net.cluster.channel.tcp.OutboundTcpNode;
import org.echocat.jomon.net.cluster.channel.tcp.TcpNode;
import org.echocat.jomon.net.cluster.channel.tcp.TcpNodeInfo;
import org.echocat.jomon.runtime.StringUtils;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.jaxb.InetSocketAddressPropertyEditor;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TcpClusterChannel
extends NetBasedClusterChannel<UUID, TcpNode>
implements AddressEnabledClusterChannel<UUID, TcpNode>,
SendingQueueEnabledClusterChannel<UUID, TcpNode>,
RemoteAddressesEnabledClusterChannel<UUID, TcpNode>,
ServiceEnabledClusterChannel<UUID, TcpNode>,
BlockableClusterChannel<UUID, TcpNode>,
DropMessagesEnabledClusterChannel<UUID, TcpNode> {
    public static final int DEFAULT_PORT = 56876;
    public static final Duration RETRY_DURATION = new Duration("10s");
    private static final Logger LOG = LoggerFactory.getLogger(TcpClusterChannel.class);
    private final Set<InboundTcpWorker> _inboundWorkers = new HashSet<InboundTcpWorker>();
    private final InboundTcpWorker.Reader _reader = new InboundTcpWorker.Reader(){

        @Override
        public void read(@Nonnull ReceivedMessage<TcpNode> message) throws IOException {
            TcpClusterChannel.this.read(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(@Nonnull InboundTcpWorker worker) {
            Lock lock = TcpClusterChannel.this.getLock();
            try {
                lock.lockInterruptibly();
                try {
                    TcpClusterChannel.this._inboundWorkers.remove(worker);
                }
                finally {
                    lock.unlock();
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    };
    private String _service = "ttc";
    private Duration _connectionTimeout = new Duration("2s");
    private Collection<InetSocketAddress> _remoteAddresses;
    private InetSocketAddress _address = new InetSocketAddress(56876);
    private int _maxNumberOfIncomingConnections = 100;
    private int _numberOfIncomingWorker = 10;
    private int _sendingQueueCapacity = 250;
    private boolean _blocking = true;
    private boolean _dropMessagesIfQueueIsFull;
    private OutboundTcpHandler _outbound;
    private ServerSocket _in;
    private Acceptor _acceptor;

    public TcpClusterChannel() {
    }

    public TcpClusterChannel(@Nullable UUID uuid) {
        super(uuid);
    }

    @Override
    @Nonnull
    public UUID getId() {
        return this.getUuid();
    }

    @Override
    @Nonnull
    public String getService() {
        return this._service;
    }

    @Override
    public void setService(final @Nonnull String service) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.this._service = service;
                return null;
            }
        });
    }

    public Duration getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(final Duration connectionTimeout) {
        this.doSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.this._connectionTimeout = connectionTimeout;
                if (TcpClusterChannel.this._outbound != null) {
                    TcpClusterChannel.this._outbound.setConnectionTimeout(connectionTimeout);
                }
                return null;
            }
        });
    }

    @Override
    @Nullable
    public Collection<InetSocketAddress> getRemoteAddresses() {
        return this._remoteAddresses;
    }

    @Override
    public void setRemoteAddresses(final @Nullable Collection<InetSocketAddress> remoteAddresses) {
        this.doSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (remoteAddresses != null ? !remoteAddresses.equals(TcpClusterChannel.this._remoteAddresses) : TcpClusterChannel.this._remoteAddresses != null) {
                    TcpClusterChannel.this._remoteAddresses = remoteAddresses;
                    if (TcpClusterChannel.this._outbound != null) {
                        TcpClusterChannel.this._outbound.setInputs(remoteAddresses);
                        try {
                            TcpClusterChannel.this._outbound.check();
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                return null;
            }
        });
    }

    @Override
    @Nullable
    public String getRemoteAddressesAsString() {
        String result;
        Collection<InetSocketAddress> remoteAddresses = this._remoteAddresses;
        if (remoteAddresses != null) {
            StringBuilder sb = new StringBuilder();
            for (InetSocketAddress address : remoteAddresses) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(address.getHostString()).append(':').append(address.getPort());
            }
            result = sb.toString();
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void setRemoteAddressesAsString(@Nullable String remoteAddressesAsString) {
        ArrayList<InetSocketAddress> addresses;
        if (remoteAddressesAsString != null) {
            String[] remoteAddressesAsStrings;
            addresses = new ArrayList<InetSocketAddress>();
            for (String remoteAddressAsString : remoteAddressesAsStrings = StringUtils.split((String)remoteAddressesAsString, (String)",;\n\r\t", (boolean)false, (boolean)true)) {
                InetSocketAddressPropertyEditor editor = new InetSocketAddressPropertyEditor();
                editor.setAsText(remoteAddressAsString);
                Object value = editor.getValue();
                if (!(value instanceof InetSocketAddress)) continue;
                addresses.add((InetSocketAddress)value);
            }
        } else {
            addresses = null;
        }
        this.setRemoteAddresses(addresses);
    }

    @Override
    public int getSendingQueueCapacity() {
        return this._sendingQueueCapacity;
    }

    @Override
    public void setSendingQueueCapacity(final int sendingQueueCapacity) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.this._sendingQueueCapacity = sendingQueueCapacity;
                return null;
            }
        });
    }

    @Override
    public boolean isBlocking() {
        return this._blocking;
    }

    @Override
    public void setBlocking(final boolean blocking) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.this._blocking = blocking;
                return null;
            }
        });
    }

    @Override
    public boolean isDropMessagesIfQueueIsFull() {
        return this._dropMessagesIfQueueIsFull;
    }

    @Override
    public void setDropMessagesIfQueueIsFull(final boolean dropMessagesIfQueueIsFull) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.this._dropMessagesIfQueueIsFull = dropMessagesIfQueueIsFull;
                return null;
            }
        });
    }

    @Override
    @Nullable
    public InetSocketAddress getAddress() {
        return this._address;
    }

    @Override
    public void setAddress(final @Nullable InetSocketAddress address) {
        this.doSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (address != null ? !address.equals(TcpClusterChannel.this._address) : TcpClusterChannel.this._address != null) {
                    TcpClusterChannel.this._address = address;
                    ResourceUtils.closeQuietly((Object)TcpClusterChannel.this._in);
                    TcpClusterChannel.this._in = null;
                    ResourceUtils.closeQuietly((Iterable)TcpClusterChannel.this._inboundWorkers);
                }
                return null;
            }
        });
    }

    @Nonnegative
    public int getNumberOfIncomingWorker() {
        return this._numberOfIncomingWorker;
    }

    public void setNumberOfIncomingWorker(final @Nonnegative int numberOfIncomingWorker) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.this._numberOfIncomingWorker = numberOfIncomingWorker;
                return null;
            }
        });
    }

    @Nonnegative
    public int getMaxNumberOfIncomingConnections() {
        return this._maxNumberOfIncomingConnections;
    }

    public void setMaxNumberOfIncomingConnections(@Nonnegative int maxNumberOfIncomingConnections) {
        this._maxNumberOfIncomingConnections = maxNumberOfIncomingConnections;
    }

    @Override
    public void setSoTimeout(final @Nonnull Duration soTimeout) {
        this.doSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.super.setSoTimeout(soTimeout);
                if (TcpClusterChannel.this._outbound != null) {
                    TcpClusterChannel.this._outbound.setSoTimeout(soTimeout);
                }
                return null;
            }
        });
    }

    @Override
    public void setPingInterval(final @Nonnull Duration pingInterval) {
        this.doSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TcpClusterChannel.super.setPingInterval(pingInterval);
                if (TcpClusterChannel.this._outbound != null) {
                    TcpClusterChannel.this._outbound.setCheckInterval(pingInterval);
                }
                return null;
            }
        });
    }

    @Override
    protected void initInLock() throws Exception {
        super.initInLock();
        this._outbound = new OutboundTcpHandler(this.getService(), this.getUuid(), this.getSendingQueueCapacity(), this.getName(), this.isBlocking(), this.isDropMessagesIfQueueIsFull());
        this._outbound.setConnectionTimeout(this.getConnectionTimeout());
        this._outbound.setSoTimeout(this.getSoTimeout());
        this._outbound.setCheckInterval(this.getPingInterval());
        this._outbound.setInputs(this.getRemoteAddresses());
        this._acceptor = new Acceptor();
        this._acceptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeInLock() throws Exception {
        try {
            ResourceUtils.closeQuietly((Object)this._in);
            ResourceUtils.closeQuietly((Object)((Object)this._outbound));
            ThreadUtils.stop((Thread)this._acceptor);
            ThreadUtils.stop(this._inboundWorkers);
            ResourceUtils.closeQuietly((Object)this._in);
        }
        finally {
            super.closeInLock();
            this._in = null;
            this._outbound = null;
            this._acceptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ServerSocket getIn() throws IOException, InterruptedException {
        Lock lock = this.getLock();
        lock.lockInterruptibly();
        try {
            if (this._in != null && (this._in.isClosed() || !this._in.isBound())) {
                ResourceUtils.closeQuietly((Object)this._in);
                this._in = null;
            }
            if (this._in == null && this._address != null) {
                this._in = new ServerSocket();
                this._in.bind(this._address);
                this._in.setReuseAddress(true);
                this._in.setSoTimeout((int)this.getSoTimeout().toMilliSeconds());
                LOG.info("Start to listen at " + this._address.getAddress().getCanonicalHostName() + ":" + this._address.getPort() + " for " + this._service + "...");
            }
            ServerSocket serverSocket = this._in;
            return serverSocket;
        }
        finally {
            lock.unlock();
        }
    }

    @Nonnull
    protected OutboundTcpHandler getOutbound() {
        return this.doSafe(new Callable<OutboundTcpHandler>(){

            @Override
            public OutboundTcpHandler call() throws Exception {
                if (TcpClusterChannel.this._outbound == null) {
                    throw new IllegalStateException("Init was not called yet.");
                }
                return TcpClusterChannel.this._outbound;
            }
        });
    }

    @Override
    public void ping() {
        this.getOutbound().sendPing();
    }

    @Override
    protected void readPing(@Nonnull ReceivedMessage<TcpNode> message) {
    }

    @Override
    public void send(@Nonnull Message message) throws IllegalArgumentException {
        try {
            this.getOutbound().send(message);
            this.recordMessageSend();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("It was not possible to send " + message + ".", e);
        }
    }

    @Override
    public void send(@Nonnull Message message, @Nonnegative long timeout, @Nonnull TimeUnit unit) throws IllegalArgumentException {
        try {
            this.getOutbound().send(message, timeout, unit);
            this.recordMessageSend();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("It was not possible to send " + message + ".", e);
        }
    }

    @Override
    public Integer getSendingQueueSize() {
        OutboundTcpHandler outbound = this._outbound;
        return outbound != null ? outbound.getCurrentMaximumQueueSize() : null;
    }

    @Override
    public boolean isConnected() {
        return this._outbound != null;
    }

    @Override
    @Nonnull
    public LocalTcpNode getLocalNode() {
        return new LocalTcpNode(this.getUuid(), this._address);
    }

    @Override
    @Nonnull
    public Set<? extends TcpNode> getNodes() {
        final AtomicReference outboundTcpNodes = new AtomicReference();
        final HashSet<InboundTcpNode> inboundTcpNodes = new HashSet<InboundTcpNode>();
        this.doSafe(new Callable<Set<? extends TcpNode>>(){

            @Override
            public Set<? extends TcpNode> call() throws Exception {
                if (TcpClusterChannel.this._outbound != null) {
                    outboundTcpNodes.set(TcpClusterChannel.this._outbound.getOutputs());
                }
                for (InboundTcpWorker worker : TcpClusterChannel.this._inboundWorkers) {
                    inboundTcpNodes.add(worker.getNode());
                }
                return null;
            }
        });
        return this.merge((Object[])outboundTcpNodes.get(), inboundTcpNodes);
    }

    @Nonnull
    protected Set<TcpNodeInfo> merge(@Nullable Object[] outboundTcpNodes, @Nullable Set<InboundTcpNode> inboundTcpNodes) {
        HashMap<UUID, TcpNodeInfo> uuidToNode = new HashMap<UUID, TcpNodeInfo>();
        if (outboundTcpNodes != null) {
            for (Object plainNode : outboundTcpNodes) {
                OutboundTcpNode node = (OutboundTcpNode)plainNode;
                UUID uuid = node.getUuid();
                TcpNodeInfo info = (TcpNodeInfo)uuidToNode.get(uuid);
                if (info == null) {
                    info = new TcpNodeInfo(uuid, node.getAddress());
                    uuidToNode.put(uuid, info);
                }
                info.setOutbound(node);
            }
        }
        if (inboundTcpNodes != null) {
            for (InboundTcpNode node : inboundTcpNodes) {
                UUID uuid = node.getUuid();
                TcpNodeInfo info = (TcpNodeInfo)uuidToNode.get(uuid);
                if (info == null) {
                    info = new TcpNodeInfo(uuid, node.getAddress());
                    uuidToNode.put(uuid, info);
                }
                info.setInbound(node);
            }
        }
        TreeSet info = new TreeSet(Node.ADDRESS_BASED_COMPARATOR);
        info.addAll(uuidToNode.values());
        return Collections.unmodifiableSet(info);
    }

    public String toString() {
        String name = this.getName();
        InetSocketAddress address = this.getAddress();
        return "TcpClusterChannel(" + this.getService() + "/" + (name != null ? name : this.getUuid()) + "):" + (address != null ? address : "<offline>");
    }

    protected class Acceptor
    extends Thread {
        public Acceptor() {
            String name = TcpClusterChannel.this.getName();
            this.setName("InboundTcp(" + TcpClusterChannel.this.getService() + "/" + (name != null ? name : TcpClusterChannel.this.getUuid()) + ").Acceptor");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!Acceptor.currentThread().isInterrupted()) {
                    try {
                        ServerSocket in = TcpClusterChannel.this.getIn();
                        if (in != null) {
                            try {
                                Socket socket = in.accept();
                                boolean success = false;
                                try {
                                    this.handleIncoming(socket);
                                    success = true;
                                    continue;
                                }
                                catch (SocketException e) {
                                    LOG.info("Could not accept connection from " + socket.getRemoteSocketAddress() + ". Got: " + e.getMessage());
                                    continue;
                                }
                                finally {
                                    if (success) continue;
                                    ResourceUtils.closeQuietly((Object)socket);
                                    continue;
                                }
                            }
                            catch (SocketException e) {
                                if (in.isClosed()) continue;
                                throw e;
                            }
                        }
                        RETRY_DURATION.sleep();
                    }
                    catch (InterruptedException ignored) {
                        Acceptor.currentThread().interrupt();
                    }
                    catch (SocketTimeoutException ignored) {
                    }
                    catch (IOException e) {
                        LOG.warn("Got error while waiting for an incoming connection. Go to sleep and retry it after " + RETRY_DURATION + "...", (Throwable)e);
                        RETRY_DURATION.sleep();
                    }
                    catch (Exception e) {
                        LOG.error("Got error while waiting for an incoming connection. Go to sleep and retry it after " + RETRY_DURATION + "...", (Throwable)e);
                        RETRY_DURATION.sleep();
                    }
                }
                return;
            }
            catch (InterruptedException ignored) {
                Acceptor.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleIncoming(@Nonnull Socket socket) throws IOException, InterruptedException {
            Lock lock = TcpClusterChannel.this.getLock();
            lock.lockInterruptibly();
            try {
                if (TcpClusterChannel.this._inboundWorkers.size() < TcpClusterChannel.this._maxNumberOfIncomingConnections) {
                    InboundTcpWorker worker = new InboundTcpWorker(TcpClusterChannel.this._reader, socket, TcpClusterChannel.this.getUuid(), TcpClusterChannel.this.getService(), TcpClusterChannel.this.getName());
                    InboundTcpNode node = worker.getNode();
                    UUID uuid = node.getUuid();
                    if (TcpClusterChannel.this.getUuid().equals(uuid)) {
                        node.close();
                    } else {
                        worker.start();
                        TcpClusterChannel.this._inboundWorkers.add(worker);
                    }
                } else {
                    LOG.warn("Dropping incoming connection from " + socket.getRemoteSocketAddress() + " because the maximum of " + TcpClusterChannel.this._maxNumberOfIncomingConnections + " is reach.");
                }
            }
            finally {
                lock.unlock();
            }
        }
    }
}

