/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CacheListener;
import org.echocat.jomon.cache.ClearableCacheListener;
import org.echocat.jomon.cache.GetCacheListener;
import org.echocat.jomon.cache.LimitedCacheListener;
import org.echocat.jomon.cache.PutCacheListener;
import org.echocat.jomon.cache.RemoveCacheListener;
import org.echocat.jomon.cache.StatisticsEnabledCacheListener;
import org.echocat.jomon.cache.Value;
import org.echocat.jomon.runtime.util.Duration;

public class CacheListenerInvoker
implements PutCacheListener,
GetCacheListener,
RemoveCacheListener,
ClearableCacheListener,
StatisticsEnabledCacheListener,
LimitedCacheListener {
    public static final PutCacheListener[] EMPTY_PUT = new PutCacheListener[0];
    public static final GetCacheListener[] EMPTY_GET = new GetCacheListener[0];
    public static final RemoveCacheListener[] EMPTY_REMOVE = new RemoveCacheListener[0];
    public static final ClearableCacheListener[] EMPTY_CLEARABLE = new ClearableCacheListener[0];
    public static final StatisticsEnabledCacheListener[] EMPTY_STATISTICS = new StatisticsEnabledCacheListener[0];
    public static final LimitedCacheListener[] EMPTY_LIMITED = new LimitedCacheListener[0];
    private Collection<CacheListener> _all;
    private PutCacheListener[] _put = EMPTY_PUT;
    private GetCacheListener[] _get = EMPTY_GET;
    private RemoveCacheListener[] _remove = EMPTY_REMOVE;
    private ClearableCacheListener[] _clearable = EMPTY_CLEARABLE;
    private StatisticsEnabledCacheListener[] _statistics = EMPTY_STATISTICS;
    private LimitedCacheListener[] _limited = EMPTY_LIMITED;

    public void setListeners(@Nullable Collection<CacheListener> listeners) {
        this._all = listeners;
        this._put = (PutCacheListener[])this.filter(PutCacheListener.class, listeners);
        this._get = (GetCacheListener[])this.filter(GetCacheListener.class, listeners);
        this._remove = (RemoveCacheListener[])this.filter(RemoveCacheListener.class, listeners);
        this._clearable = (ClearableCacheListener[])this.filter(ClearableCacheListener.class, listeners);
        this._statistics = (StatisticsEnabledCacheListener[])this.filter(StatisticsEnabledCacheListener.class, listeners);
        this._limited = (LimitedCacheListener[])this.filter(LimitedCacheListener.class, listeners);
    }

    public Collection<CacheListener> getListeners() {
        return this._all;
    }

    @Override
    public boolean beforePut(@Nonnull Cache<?, ?> cache, @Nullable Object key, @Nullable Value<?> value, @Nullable Duration expireAfter) {
        boolean result = true;
        PutCacheListener[] listeners = this._put;
        for (int i = 0; result && i < listeners.length; ++i) {
            result = listeners[i].beforePut(cache, key, value, expireAfter);
        }
        return result;
    }

    @Override
    public void afterPut(@Nonnull Cache<?, ?> cache, @Nullable Object key, @Nullable Value<?> value, @Nullable Duration expireAfter) {
        PutCacheListener[] listeners;
        for (PutCacheListener listener : listeners = this._put) {
            listener.afterPut(cache, key, value, expireAfter);
        }
    }

    @Override
    public boolean beforeGet(@Nonnull Cache<?, ?> cache, @Nullable Object key) {
        boolean result = true;
        GetCacheListener[] listeners = this._get;
        for (int i = 0; result && i < listeners.length; ++i) {
            result = listeners[i].beforeGet(cache, key);
        }
        return result;
    }

    @Override
    public void afterGet(@Nonnull Cache<?, ?> cache, @Nullable Object key, @Nullable Value<?> value) {
        GetCacheListener[] listeners;
        for (GetCacheListener listener : listeners = this._get) {
            listener.afterGet(cache, key, value);
        }
    }

    @Override
    public boolean beforeRemove(@Nonnull Cache<?, ?> cache, @Nullable Object key) {
        boolean result = true;
        RemoveCacheListener[] listeners = this._remove;
        for (int i = 0; result && i < listeners.length; ++i) {
            result = listeners[i].beforeRemove(cache, key);
        }
        return result;
    }

    @Override
    public void afterRemove(@Nonnull Cache<?, ?> cache, @Nullable Object key, @Nullable Value<?> oldValue) {
        RemoveCacheListener[] listeners;
        for (RemoveCacheListener listener : listeners = this._remove) {
            listener.afterRemove(cache, key, oldValue);
        }
    }

    @Override
    public boolean beforeClear(@Nonnull Cache<?, ?> cache) {
        boolean result = true;
        ClearableCacheListener[] listeners = this._clearable;
        for (int i = 0; result && i < listeners.length; ++i) {
            result = listeners[i].beforeClear(cache);
        }
        return result;
    }

    @Override
    public void afterClear(@Nonnull Cache<?, ?> cache) {
        ClearableCacheListener[] listeners;
        for (ClearableCacheListener listener : listeners = this._clearable) {
            listener.afterClear(cache);
        }
    }

    @Override
    public boolean beforeResetStatistics(@Nonnull Cache<?, ?> cache) {
        boolean result = true;
        StatisticsEnabledCacheListener[] listeners = this._statistics;
        for (int i = 0; result && i < listeners.length; ++i) {
            result = listeners[i].beforeResetStatistics(cache);
        }
        return result;
    }

    @Override
    public void afterResetStatistics(@Nonnull Cache<?, ?> cache) {
        StatisticsEnabledCacheListener[] listeners;
        for (StatisticsEnabledCacheListener listener : listeners = this._statistics) {
            listener.afterResetStatistics(cache);
        }
    }

    @Override
    public boolean beforeSetMaximumLifetime(@Nonnull Cache<?, ?> cache, @Nullable Duration millis) {
        boolean result = true;
        LimitedCacheListener[] listeners = this._limited;
        for (int i = 0; result && i < listeners.length; ++i) {
            result = listeners[i].beforeSetMaximumLifetime(cache, millis);
        }
        return result;
    }

    @Override
    public void afterSetMaximumLifetime(@Nonnull Cache<?, ?> cache, @Nullable Duration millis) {
        LimitedCacheListener[] listeners;
        for (LimitedCacheListener listener : listeners = this._limited) {
            listener.afterSetMaximumLifetime(cache, millis);
        }
    }

    @Nonnull
    protected <T extends CacheListener> T[] filter(@Nonnull Class<T> requiredType, @Nullable Collection<CacheListener> all) {
        ArrayList<T> result = new ArrayList<T>();
        if (all != null) {
            for (CacheListener listener : all) {
                if (!requiredType.isInstance(listener)) continue;
                result.add(requiredType.cast(listener));
            }
        }
        return result.toArray((CacheListener[])Array.newInstance(requiredType, result.size()));
    }
}

