/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CacheSupport;
import org.echocat.jomon.cache.IdentifiedCache;
import org.echocat.jomon.cache.Value;
import org.echocat.jomon.cache.management.CacheCreator;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.DefaultCacheDefinition;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ProducingType;
import org.echocat.jomon.runtime.util.ValueProducer;

public class ServletRequestBasedCache<K, V>
extends CacheSupport<K, V>
implements IdentifiedCache<K, V> {
    private final CacheCreator _cacheCreator;
    private final Resolver _resolver;
    private final CacheDefinition<? extends K, ? extends V, ?> _delegateDefinition;
    private String _id;

    public ServletRequestBasedCache(@Nonnull Class<? extends K> keyType, @Nonnull Class<? extends V> valueType, @Nonnull CacheCreator cacheCreator, @Nonnull Resolver resolver, @Nullable CacheDefinition<? extends K, ? extends V, ?> delegateDefinition) {
        super(keyType, valueType);
        this._cacheCreator = cacheCreator;
        this._resolver = resolver;
        this._delegateDefinition = delegateDefinition != null ? delegateDefinition : DefaultCacheDefinition.lruCache(keyType, valueType);
    }

    public ServletRequestBasedCache(@Nonnull Class<? extends K> keyType, @Nonnull Class<? extends V> valueType, @Nonnull CacheCreator cacheCreator, @Nonnull Resolver resolver) {
        this(keyType, valueType, cacheCreator, resolver, null);
    }

    @Override
    public void put(@Nullable K key, @Nullable V value) {
        Cache<K, V> cache = this.findRequestBasedCache();
        if (cache != null) {
            cache.put(key, value);
        }
    }

    @Override
    public void put(@Nullable K key, @Nullable V value, @Nullable Duration expireAfter) {
        Cache<K, V> cache = this.findRequestBasedCache();
        if (cache != null) {
            cache.put(key, value, expireAfter);
        }
    }

    @Override
    @Nullable
    public V get(@Nullable K key) {
        Cache<K, V> cache = this.findRequestBasedCache();
        return cache != null ? (V)cache.get(key) : null;
    }

    @Override
    @Nullable
    public V get(@Nullable K key, @Nullable ValueProducer<K, V> cacheValueProducer, @Nullable Duration expireAfter) {
        Cache<K, V> cache = this.findRequestBasedCache();
        return cache != null ? cache.get(key, cacheValueProducer, expireAfter) : new Value.Lazy<K, V>(key, cacheValueProducer, ProducingType.blocking).get();
    }

    @Override
    @Nullable
    public V get(@Nullable K key, @Nullable ValueProducer<K, V> cacheValueProducer) {
        Cache<K, V> cache = this.findRequestBasedCache();
        return cache != null ? cache.get(key, cacheValueProducer) : new Value.Lazy<K, V>(key, cacheValueProducer, ProducingType.blocking).get();
    }

    @Override
    @Nullable
    public Value<V> remove(@Nullable K key) {
        Cache<K, V> cache = this.findRequestBasedCache();
        return cache != null ? cache.remove(key) : null;
    }

    @Override
    public boolean contains(@Nullable K key) {
        Cache<K, V> cache = this.findRequestBasedCache();
        return cache != null && cache.contains(key);
    }

    @Nullable
    protected Cache<K, V> findRequestBasedCache() {
        ServletRequest request = this._resolver.resolve(this);
        Cache<K, V> result = request != null ? this.findCacheAt(request) : null;
        return result;
    }

    @Nullable
    protected Cache<K, V> findCacheAt(ServletRequest request) {
        Cache<K, V> result;
        String requestCacheAttributeName = this.getRequestCacheAttributeName();
        Object plainCache = request.getAttribute(requestCacheAttributeName);
        if (plainCache == null) {
            result = this.checkedCreation();
            request.setAttribute(requestCacheAttributeName, result);
        } else if (plainCache instanceof Cache) {
            result = this.checkedCast(plainCache);
        } else {
            throw new IllegalStateException("The request attribute " + requestCacheAttributeName + " contains not a cache: " + plainCache);
        }
        return result;
    }

    @Nonnull
    protected Cache<K, V> checkedCreation() {
        try {
            return this._cacheCreator.create(null, this._cacheCreator, this._delegateDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create cache for request with " + this._delegateDefinition + ".", e);
        }
    }

    @Nonnull
    protected Cache<K, V> checkedCast(@Nonnull Object plainCache) {
        Cache result = (Cache)plainCache;
        if (!this.getKeyType().isAssignableFrom(result.getKeyType()) || !this.getValueType().isAssignableFrom(result.getValueType())) {
            throw new IllegalStateException("The request attribute " + this.getRequestCacheAttributeName() + " contains in invalid cache: " + result);
        }
        return result;
    }

    @Nonnull
    public String getRequestCacheAttributeName() {
        return this._id != null ? this.getClass().getName() + "." + this._id : this.getClass().getName();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Nonnull
    public CacheCreator getCacheCreator() {
        return this._cacheCreator;
    }

    @Nonnull
    public Resolver getResolver() {
        return this._resolver;
    }

    @Nonnull
    public CacheDefinition<? extends K, ? extends V, ?> getDelegateDefinition() {
        return this._delegateDefinition;
    }

    public static interface Resolver {
        @Nullable
        public ServletRequest resolve(@Nonnull ServletRequestBasedCache<?, ?> var1);
    }
}

