/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.util.GotInterruptedException;
import org.echocat.jomon.runtime.util.PostProducing;
import org.echocat.jomon.runtime.util.ProducingType;
import org.echocat.jomon.runtime.util.ValueProducer;
import org.echocat.jomon.runtime.util.ValueProducingFailedException;

public interface Value<V> {
    @Nullable
    public V get();

    @ThreadSafe
    public static class Lazy<K, V>
    implements Value<V> {
        private final K _key;
        private final ValueProducer<K, V> _producer;
        private final ProducingType _producingType;
        private volatile V _value;
        private volatile Exception _producingException;
        private volatile ValueState _valueState = ValueState.notProducedYet;

        public Lazy(@Nullable K key, @Nullable ValueProducer<K, V> producer, @Nonnull ProducingType producingType) {
            this._key = key;
            this._producer = producer;
            this._producingType = producingType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() {
            V result;
            if (this._valueState == ValueState.produced) {
                result = this._value;
            } else {
                if (this._producingType == ProducingType.blocking) {
                    ValueProducer<K, V> valueProducer = this._producer;
                    synchronized (valueProducer) {
                        if (this._valueState == ValueState.notProducedYet) {
                            this.callProducer();
                        } else {
                            this.waitWhileProducerIsActive();
                        }
                    }
                } else if (this._producingType == ProducingType.nonBlocking) {
                    this.callProducer();
                } else {
                    throw new IllegalStateException("Could not handle producingType " + this._producingType + ".");
                }
                if (this._valueState == ValueState.produced) {
                    result = this._value;
                } else {
                    if (this._valueState == ValueState.producingFailed) {
                        throw new ValueProducingFailedException(this._key, (Throwable)this._producingException);
                    }
                    throw new IllegalStateException("Unexpected _valueState: " + (Object)((Object)this._valueState));
                }
            }
            return result;
        }

        @Nullable
        public V getWithoutProducing() {
            return this._value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value="_producer")
        private void callProducer() {
            this._valueState = ValueState.producing;
            try {
                this._value = this._producer.produce(this._key);
                this._valueState = ValueState.produced;
            }
            catch (Exception e) {
                this._producingException = e;
                this._valueState = ValueState.producingFailed;
            }
            finally {
                try {
                    if (this._valueState == ValueState.producing) {
                        this._valueState = ValueState.producingFailed;
                    }
                }
                finally {
                    try {
                        if (this._producingType == ProducingType.blocking) {
                            this._producer.notifyAll();
                        }
                    }
                    finally {
                        if (this._valueState == ValueState.produced && this._producer instanceof PostProducing) {
                            try {
                                ((PostProducing)this._producer).postProducing(this._key, this._value);
                            }
                            catch (Exception e) {
                                this._producingException = e;
                                this._valueState = ValueState.producingFailed;
                            }
                        }
                    }
                }
            }
        }

        @GuardedBy(value="_producer")
        private void waitWhileProducerIsActive() {
            if (this._producingType != ProducingType.blocking) {
                throw new IllegalStateException("This method could only be used if producingType is " + ProducingType.blocking + ".");
            }
            while (this._valueState == ValueState.producing) {
                try {
                    this._producer.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new GotInterruptedException("Got interrupted while waiting for production of cache value for key " + this._key + ".", (Throwable)e);
                }
            }
        }

        static enum ValueState {
            notProducedYet,
            producing,
            produced,
            producingFailed;

        }
    }

    @ThreadSafe
    public static class Fixed<V>
    implements Value<V> {
        private final V _value;

        @Nullable
        public static <V> Fixed<V> fixed(@Nullable V value) {
            return value != null ? new Fixed<V>(value) : null;
        }

        public Fixed(V value) {
            this._value = value;
        }

        @Override
        public V get() {
            return this._value;
        }

        public String toString() {
            V value = this.get();
            return value != null ? value.toString() : "null";
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof Value)) {
                result = false;
            } else {
                Value that = (Value)o;
                V value = this.get();
                result = value != null ? value.equals(that.get()) : that.get() == null;
            }
            return result;
        }

        public int hashCode() {
            V value = this.get();
            return value != null ? value.hashCode() : 0;
        }
    }
}

