/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.support.PutInCacheIterator;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.IdEnabled;
import org.echocat.jomon.runtime.util.ResourceUtils;

public abstract class OptimizedByCacheIterator<K, T extends IdEnabled<K>>
implements CloseableIterator<T> {
    private final Cache<K, T> _cache;
    private final Iterable<K> _ids;
    private volatile Iterator<T> _fromCache;
    private volatile List<K> _idsNotInCache;
    private volatile Iterator<T> _delegate;

    public OptimizedByCacheIterator(@Nonnull Cache<K, T> cache, @Nonnull Iterable<K> ids) {
        this._cache = cache;
        this._ids = ids;
    }

    @Nullable
    protected abstract Iterator<T> getDelegateFor(@Nonnull List<K> var1);

    public boolean hasNext() {
        boolean result;
        if (this._fromCache == null) {
            ArrayList<IdEnabled> fromCache = new ArrayList<IdEnabled>();
            ArrayList<K> idsNotInCache = new ArrayList<K>();
            for (K id : this._ids) {
                IdEnabled cached = (IdEnabled)this._cache.get(id);
                if (cached != null) {
                    fromCache.add(cached);
                    continue;
                }
                idsNotInCache.add(id);
            }
            this._fromCache = fromCache.iterator();
            this._idsNotInCache = idsNotInCache;
        }
        if (this._fromCache.hasNext()) {
            result = true;
        } else if (!this._fromCache.hasNext() && this._delegate == null) {
            CloseableIterator delegate = this.getDelegateFor(this._idsNotInCache);
            this._delegate = new PutInCacheIterator<K, T>(delegate != null ? delegate : CollectionUtils.emptyIterator(), this._cache);
            result = this._delegate.hasNext();
        } else {
            result = this._delegate.hasNext();
        }
        return result;
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (T)(this._delegate != null ? (IdEnabled)this._delegate.next() : (IdEnabled)this._fromCache.next());
    }

    public void close() {
        ResourceUtils.closeQuietly(this._delegate);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

