/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache.support;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.IdEnabled;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class PutInCacheIterator<K, T extends IdEnabled<K>>
implements CloseableIterator<T> {
    private final Iterator<T> _delegate;
    private final Cache<K, T> _cache;

    public PutInCacheIterator(@Nonnull Iterator<T> delegate, @Nonnull Cache<K, T> cache) {
        this._delegate = delegate;
        this._cache = cache;
    }

    public void close() {
        ResourceUtils.closeQuietly(this._delegate);
    }

    public boolean hasNext() {
        return this._delegate.hasNext();
    }

    public T next() {
        IdEnabled next = (IdEnabled)this._delegate.next();
        if (next != null) {
            this._cache.put(next.getId(), next);
        }
        return (T)next;
    }

    public void remove() {
        this._delegate.remove();
    }
}

