/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xbill.DNS.Address;

public class AddressUtils {
    @Nonnull
    public static InetAddress toInetAddress(@Nullable String hostName, @Nonnull String ipAsString) {
        return AddressUtils.toInetAddress(hostName, AddressUtils.toAddress(ipAsString));
    }

    @Nonnull
    public static InetAddress toInetAddress(@Nullable String hostName, @Nonnull byte[] address) {
        try {
            return InetAddress.getByAddress(hostName, address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    public static byte[] toAddress(@Nonnull String ipAsString) {
        byte[] address = Address.toByteArray((String)ipAsString, (int)1);
        if (address == null) {
            address = Address.toByteArray((String)ipAsString, (int)2);
        }
        if (address == null) {
            throw new IllegalArgumentException(ipAsString + " is no valid ip in string format.");
        }
        return address;
    }

    private AddressUtils() {
    }
}

