/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.Process;

public class GeneratedProcessImpl
implements GeneratedProcess {
    private final Process _placeHolder;
    private final java.lang.Process _original;
    private final boolean _isDaemon;

    public GeneratedProcessImpl(@Nonnull Process placeHolder, @Nonnull java.lang.Process original, boolean isDaemon) {
        this._placeHolder = placeHolder;
        this._original = original;
        this._isDaemon = isDaemon;
    }

    @Override
    public long getId() {
        return this._placeHolder.getId();
    }

    @Override
    @Nullable
    public File getExecutable() {
        return this._placeHolder.getExecutable();
    }

    @Override
    @Nullable
    public String[] getCommandLine() {
        return this._placeHolder.getCommandLine();
    }

    @Override
    public boolean isPathCaseSensitive() {
        return this._placeHolder.isPathCaseSensitive();
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream() {
        return this._original.getOutputStream();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        return this._original.getInputStream();
    }

    @Override
    @Nonnull
    public InputStream getErrorStream() {
        return this._original.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this._original.waitFor();
    }

    @Override
    public int exitValue() {
        try {
            return this._original.exitValue();
        }
        catch (IllegalThreadStateException e) {
            throw new IllegalStateException("Process is still running.", e);
        }
    }

    @Override
    public boolean isAlive() {
        boolean result;
        try {
            result = this._original.exitValue() >= 0;
        }
        catch (IllegalThreadStateException ignored) {
            result = false;
        }
        return result;
    }

    @Override
    public void shutdown() {
        this._original.destroy();
    }

    @Override
    public boolean isDaemon() {
        return this._isDaemon;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof GeneratedProcess)) {
            result = false;
        } else {
            GeneratedProcess that = (GeneratedProcess)o;
            result = this.getId() == that.getId();
        }
        return result;
    }

    public int hashCode() {
        long id = this.getId();
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        return "Process #" + this.getId();
    }
}

