/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.runtime.util.ResourceUtils;

@ThreadSafe
public class GeneratedProcessRegistry
implements AutoCloseable {
    private static final String DEFAULT_IDS_FILE_DIRECTORY_PATH = System.getProperty("user.home", File.separator) + File.separator + ".parentProcessRegistry";
    public static final File IDS_FILE_DIRECTORY = GeneratedProcessRegistry.getIdsFileDirectory();
    private final Map<Long, Long> _processIdToFilePosition = new HashMap<Long, Long>();
    private final Set<Long> _freeFilePositions = new HashSet<Long>();
    private final File _file;
    private final RandomAccessFile _access;

    public GeneratedProcessRegistry(long parentProcessId) {
        this._file = GeneratedProcessRegistry.getIdsFileFor(parentProcessId);
        this._access = this.openIdsFile(this._file);
    }

    @Nonnull
    protected RandomAccessFile openIdsFile(@Nonnull File file) {
        try {
            return new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not open ids file (" + file + ").", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@Nonnull GeneratedProcess process) {
        if (process.isDaemon()) {
            long id = process.getId();
            GeneratedProcessRegistry generatedProcessRegistry = this;
            synchronized (generatedProcessRegistry) {
                if (!this._processIdToFilePosition.containsKey(id)) {
                    this.registerUnknownProcessWith(id);
                    this.startAutomaticDeRegistrationFor(process);
                }
            }
        }
    }

    protected void startAutomaticDeRegistrationFor(@Nonnull GeneratedProcess process) {
        Thread waiter = new Thread((Runnable)new WaitForEnd(process), "Wait for end of " + process);
        waiter.setDaemon(true);
        waiter.start();
    }

    @GuardedBy(value="this")
    protected void registerUnknownProcessWith(long id) {
        long position = this.getFreePosition();
        try {
            this._access.seek(position);
            this._access.writeLong(id);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write id " + id + " at position " + position + " in " + this._access + ".", e);
        }
        this._processIdToFilePosition.put(id, position);
        this._freeFilePositions.remove(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@Nonnull GeneratedProcess process) {
        if (process.isDaemon()) {
            long id = process.getId();
            GeneratedProcessRegistry generatedProcessRegistry = this;
            synchronized (generatedProcessRegistry) {
                if (this._processIdToFilePosition.containsKey(id)) {
                    this.unregisterKnownProcessWith(id);
                }
            }
        }
    }

    @Nonnull
    public Set<Long> getAllIds() {
        GeneratedProcessRegistry generatedProcessRegistry = this;
        synchronized (generatedProcessRegistry) {
            try {
                boolean hasNext;
                HashSet<Long> result = new HashSet<Long>((int)(this._access.length() / 8L));
                this._access.seek(0L);
                do {
                    try {
                        long id = this._access.readLong();
                        if (id != 0L) {
                            result.add(id);
                        }
                        hasNext = true;
                    }
                    catch (EOFException ignored) {
                        hasNext = false;
                    }
                } while (hasNext);
                return Collections.unmodifiableSet(result);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read stored ids from " + this._access + ".", e);
            }
        }
    }

    @GuardedBy(value="this")
    protected void unregisterKnownProcessWith(long id) {
        Long position = this._processIdToFilePosition.get(id);
        if (position != null) {
            try {
                this._access.seek(position);
                this._access.writeLong(0L);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not delete id " + id + " at position " + position + " from " + this._access + ".", e);
            }
            this._processIdToFilePosition.remove(id);
            this._freeFilePositions.add(position);
        }
    }

    @Nonnegative
    @GuardedBy(value="this")
    protected long getFreePosition() {
        long result;
        Iterator<Long> i = this._freeFilePositions.iterator();
        if (i.hasNext()) {
            result = i.next();
        } else {
            try {
                result = this._access.length();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not retrieve the length of " + this._access + ".", e);
            }
        }
        return result;
    }

    @Nonnull
    public static File getIdsFileFor(@Nonnegative long parentProcessId) {
        return new File(IDS_FILE_DIRECTORY, Long.toString(parentProcessId));
    }

    @Nonnull
    public static long[] getParentProcessIds() {
        String[] plainIds = IDS_FILE_DIRECTORY.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean result;
                try {
                    Long.valueOf(name);
                    result = true;
                }
                catch (NumberFormatException ignored) {
                    result = false;
                }
                return result;
            }
        });
        long[] ids = new long[plainIds.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Long.valueOf(plainIds[i]);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GeneratedProcessRegistry generatedProcessRegistry = this;
        synchronized (generatedProcessRegistry) {
            try {
                ResourceUtils.closeQuietly((Object)this._access);
            }
            finally {
                this._file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Nonnull
    private static File getIdsFileDirectory() {
        String idsFileDirectoryPath = System.getProperty(GeneratedProcessRegistry.class + ".idsFileDirectory", DEFAULT_IDS_FILE_DIRECTORY_PATH);
        File idsFileDirectory = new File(idsFileDirectoryPath);
        idsFileDirectory.mkdirs();
        if (!idsFileDirectory.isDirectory()) {
            throw new IllegalArgumentException("Illegal idsFileDirectory specified: " + idsFileDirectoryPath);
        }
        return idsFileDirectory;
    }

    protected class WaitForEnd
    implements Runnable {
        private final GeneratedProcess _process;

        public WaitForEnd(GeneratedProcess process) {
            this._process = process;
        }

        @Override
        public void run() {
            try {
                this._process.waitFor();
                GeneratedProcessRegistry.this.unregister(this._process);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

