/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.generation.Requirement;

public class GeneratedProcessRequirement
implements Requirement {
    private final Map<String, String> _environment = new HashMap<String, String>();
    private final List<String> _arguments = new ArrayList<String>();
    private final String _executable;
    private File _workingDirectory = new File(System.getProperty("user.dir", "."));
    private boolean _daemon;

    @Nonnull
    public static GeneratedProcessRequirement process(@Nonnull File executable) {
        return new GeneratedProcessRequirement(executable);
    }

    @Nonnull
    public static GeneratedProcessRequirement process(@Nonnull String executable) {
        return new GeneratedProcessRequirement(executable);
    }

    public GeneratedProcessRequirement(@Nonnull File executable) {
        this(executable.getPath());
    }

    public GeneratedProcessRequirement(@Nonnull String executable) {
        this._executable = executable;
    }

    @Nonnull
    public GeneratedProcessRequirement withArgument(@Nonnull String argument) {
        return this.withArguments(argument);
    }

    @Nonnull
    public GeneratedProcessRequirement withArguments(String ... arguments) {
        return this.withArguments(Arrays.asList(arguments));
    }

    @Nonnull
    public GeneratedProcessRequirement withArguments(@Nonnull Iterable<String> arguments) {
        for (String argument : arguments) {
            this._arguments.add(argument);
        }
        return this;
    }

    @Nonnull
    public GeneratedProcessRequirement withWorkingDirectory(@Nonnull File workingDirectory) {
        if (workingDirectory.isDirectory()) {
            throw new IllegalArgumentException(workingDirectory + " does not exist.");
        }
        this._workingDirectory = workingDirectory;
        return this;
    }

    @Nonnull
    public GeneratedProcessRequirement withWorkingDirectory(@Nonnull String workingDirectory) {
        return this.withWorkingDirectory(new File(workingDirectory));
    }

    @Nonnull
    public GeneratedProcessRequirement withEnvironment(@Nonnull String key, @Nonnull String value) {
        this._environment.put(key, value);
        return this;
    }

    @Nonnull
    public GeneratedProcessRequirement withEnvironment(@Nonnull Map<String, String> environment) {
        this._environment.putAll(environment);
        return this;
    }

    @Nonnull
    public GeneratedProcessRequirement whichIsDaemon() {
        return this.whichIsDaemon(true);
    }

    @Nonnull
    public GeneratedProcessRequirement whichIsNoDaemon() {
        return this.whichIsDaemon(false);
    }

    @Nonnull
    public GeneratedProcessRequirement whichIsDaemon(boolean daemon) {
        this._daemon = daemon;
        return this;
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this._environment);
    }

    @Nonnull
    public List<String> getArguments() {
        return Collections.unmodifiableList(this._arguments);
    }

    @Nonnull
    public String getExecutable() {
        return this._executable;
    }

    @Nonnull
    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    @Nonnull
    public List<String> getCompleteCommandLine() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this._executable);
        command.addAll(this._arguments);
        return Collections.unmodifiableList(command);
    }
}

