/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.lang.reflect.Field;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ProcessPidResolver {
    private static final ProcessPidResolver INSTANCE = ProcessPidResolver.createInstance();

    @Nonnull
    public static ProcessPidResolver getInstance() {
        return INSTANCE;
    }

    public abstract long resolvePidOf(@Nonnull Process var1);

    @Nonnull
    protected static ProcessPidResolver createInstance() {
        ServiceLoader<ProcessPidResolver> found = ServiceLoader.load(ProcessPidResolver.class);
        ProcessPidResolver resolver = null;
        for (ProcessPidResolver candidate : found) {
            if (!candidate.couldHandleThisVirtualMachine()) continue;
            resolver = candidate;
            break;
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Could not find any matching implementation of " + ProcessPidResolver.class.getName() + " for this virtual machine.");
        }
        resolver.init();
        return resolver;
    }

    protected abstract boolean couldHandleThisVirtualMachine();

    protected abstract void init();

    @Nullable
    protected static Class<?> findClass(@Nonnull String className) {
        Class<?> result;
        try {
            result = ProcessPidResolver.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            result = null;
        }
        return result;
    }

    @Nullable
    protected static Field findFieldOf(@Nonnull String fieldName, @Nullable Class<?> ofType, @Nonnull Class<?> from) {
        Field field;
        if (from != null) {
            try {
                field = from.getDeclaredField(fieldName);
                if (!field.getType().equals(ofType)) {
                    field = null;
                }
                field.setAccessible(true);
            }
            catch (NoSuchFieldException ignored) {
                field = null;
            }
        } else {
            field = null;
        }
        return field;
    }

    @Nullable
    protected Object getFieldValue(@Nonnull Field field, @Nonnull Object instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not read value of " + field + " from " + instance + ".", e);
        }
    }
}

