/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import com.google.common.base.Predicate;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.process.Process;
import org.echocat.jomon.runtime.repository.Query;
import org.echocat.jomon.runtime.util.Glob;

public class ProcessQuery
implements Query,
Predicate<Process> {
    private List<Long> _ids;
    private File _executable;
    private Glob _commandLineGlob;

    @Nonnull
    public static ProcessQuery query() {
        return new ProcessQuery();
    }

    @Nonnull
    public ProcessQuery withId(long ... id) {
        return this.withIds(id);
    }

    @Nonnull
    public ProcessQuery withIds(long ... ids) {
        return this.withIds(ArrayUtils.toObject((long[])ids));
    }

    @Nonnull
    public ProcessQuery withIds(Long ... ids) {
        return this.withIds(Arrays.asList(ids));
    }

    @Nonnull
    public ProcessQuery withIds(@Nonnull Iterable<Long> ids) {
        ArrayList<Long> idsAsList = new ArrayList<Long>();
        for (Long id : ids) {
            idsAsList.add(id);
        }
        return this.withIds((List<Long>)idsAsList);
    }

    @Nonnull
    public ProcessQuery withIds(@Nonnull List<Long> ids) {
        if (this._ids != null) {
            throw new IllegalStateException("Ids already set.");
        }
        this._ids = ids;
        return this;
    }

    @Nonnull
    public ProcessQuery withExecutable(@Nonnull File executable) {
        if (this._executable != null) {
            throw new IllegalStateException("Executable already set.");
        }
        this._executable = executable;
        return this;
    }

    @Nonnull
    public ProcessQuery withCommandLineLike(@Nonnull String commandLineGlobPattern) {
        try {
            return this.withCommandLineLike(new Glob(commandLineGlobPattern));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal pattern: " + commandLineGlobPattern, e);
        }
    }

    @Nonnull
    public ProcessQuery withCommandLineLike(@Nonnull Glob commandLine) {
        if (this._commandLineGlob != null) {
            throw new IllegalStateException("Executable already set.");
        }
        this._commandLineGlob = commandLine;
        return this;
    }

    @Nullable
    public List<Long> getIds() {
        return this._ids;
    }

    @Nullable
    public File getExecutable() {
        return this._executable;
    }

    @Nullable
    public Glob getCommandLineGlob() {
        return this._commandLineGlob;
    }

    public boolean apply(@Nullable Process input) {
        return input != null && this.applyId(input) && this.applyExecutable(input) && this.applyCommandLine(input);
    }

    protected boolean applyId(@Nonnull Process process) {
        return this._ids == null || this._ids.contains(process.getId());
    }

    protected boolean applyExecutable(@Nonnull Process process) {
        return this._executable == null || this._executable.equals(process.getExecutable());
    }

    protected boolean applyCommandLine(@Nonnull Process process) {
        boolean result;
        if (this._commandLineGlob == null) {
            result = true;
        } else {
            Object[] commandLine = process.getCommandLine();
            if (commandLine != null) {
                String joinedCommandLine = StringUtils.join((Object[])commandLine, (char)' ');
                result = this._commandLineGlob.matches(joinedCommandLine);
            } else {
                result = false;
            }
        }
        return result;
    }
}

