/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.DummyProcess;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.GeneratedProcessImpl;
import org.echocat.jomon.process.GeneratedProcessRequirement;
import org.echocat.jomon.process.Process;
import org.echocat.jomon.process.ProcessPidResolver;
import org.echocat.jomon.process.ProcessQuery;
import org.echocat.jomon.process.Signal;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.io.UncheckedIOException;
import org.echocat.jomon.runtime.repository.QueryableRepository;

@ThreadSafe
public abstract class ProcessRepository
implements QueryableRepository<ProcessQuery, Long, Process>,
Generator<GeneratedProcess, GeneratedProcessRequirement>,
AutoCloseable {
    private static final ProcessRepository INSTANCE = ProcessRepository.createInstance();

    @Nonnull
    public static ProcessRepository getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static ProcessRepository processRepository() {
        return ProcessRepository.getInstance();
    }

    @Nullable
    public Process findOneBy(@Nonnull java.lang.Process process) {
        return this.findOneBy(this.getIdOf(process));
    }

    public Process findOneBy(@Nonnull Long id) {
        return this.findOneBy(ProcessQuery.query().withId(id));
    }

    public Process findOneBy(@Nonnull ProcessQuery query) {
        return (Process)CollectionUtils.findFirstOf((Iterator)this.findBy(query));
    }

    public long countBy(@Nonnull ProcessQuery query) {
        return CollectionUtils.countElementsOf((Iterator)this.findBy(query));
    }

    @Nonnull
    public GeneratedProcess generate(@Nonnull GeneratedProcessRequirement requirement) throws UncheckedIOException {
        java.lang.Process original;
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(requirement.getCompleteCommandLine());
        pb.environment().putAll(requirement.getEnvironment());
        pb.directory(requirement.getWorkingDirectory());
        try {
            original = pb.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        long id = this.getIdOf(original);
        Process placeHolder = this.findOneBy(id);
        return this.toControllableProcess(placeHolder != null ? placeHolder : new DummyProcess(id), original, requirement.isDaemon());
    }

    public abstract void send(@Nonnull Process var1, @Nonnull Signal var2);

    @Override
    public void close() {
    }

    protected abstract boolean couldHandleThisVirtualMachine();

    protected abstract void init();

    protected abstract long getCurrentJvmId();

    protected long getIdOf(@Nonnull java.lang.Process process) {
        return ProcessPidResolver.getInstance().resolvePidOf(process);
    }

    @Nonnull
    protected static ProcessRepository createInstance() {
        ServiceLoader<ProcessRepository> found = ServiceLoader.load(ProcessRepository.class);
        ProcessRepository processRepository = null;
        for (ProcessRepository candidate : found) {
            if (!candidate.couldHandleThisVirtualMachine()) continue;
            processRepository = candidate;
            break;
        }
        if (processRepository == null) {
            throw new IllegalArgumentException("Could not find any matching implementation of " + ProcessRepository.class.getName() + " for this virtual machine.");
        }
        processRepository.init();
        ProcessRepository.closeOnJvmShutdown(processRepository);
        return processRepository;
    }

    private static void closeOnJvmShutdown(final @Nonnull ProcessRepository processRepository) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                processRepository.close();
            }
        });
    }

    @Nonnull
    protected GeneratedProcess toControllableProcess(@Nonnull Process placeHolder, @Nonnull java.lang.Process original, boolean isDaemon) {
        return new GeneratedProcessImpl(placeHolder, original, isDaemon);
    }
}

