/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;

public class ProcessUtils {
    private static final Pattern ESCAPED_ARGUMENT_PATTERN = Pattern.compile("([\\s\"'])");

    @Nonnull
    public static String toEscapedCommandLine(@Nonnull String[] commandLine) {
        return ProcessUtils.toEscapedCommandLine(CollectionUtils.asImmutableList((Object[])commandLine));
    }

    @Nonnull
    public static String toEscapedCommandLine(@Nonnull Iterable<String> commandLine) {
        StringBuilder sb = new StringBuilder();
        for (String argument : commandLine) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (ESCAPED_ARGUMENT_PATTERN.matcher(argument).matches()) {
                sb.append('\"').append(ESCAPED_ARGUMENT_PATTERN.matcher(argument).replaceAll("\\$1")).append('\"');
                continue;
            }
            sb.append(argument);
        }
        return sb.toString();
    }

    private ProcessUtils() {
    }
}

