/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.ProcessRepository;
import org.echocat.jomon.process.daemon.ApplicationDaemonRequirement;
import org.echocat.jomon.process.daemon.CouldNotStartProcessException;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.process.daemon.listeners.startup.StartupListener;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListener;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationDaemon<R extends ApplicationDaemonRequirement<?>>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDaemon.class);
    @Nonnull
    private final R _requirement;
    @Nonnull
    private final GeneratedProcess _process;
    @Nonnull
    private final List<Thread> _monitors;
    private File _temporaryDirectory;

    protected ApplicationDaemon(@Nonnull R requirement) throws CouldNotStartProcessException {
        this(ProcessRepository.getInstance(), requirement);
    }

    protected ApplicationDaemon(@Nonnull ProcessRepository processRepository, @Nonnull R requirement) throws CouldNotStartProcessException {
        this._requirement = requirement;
        try {
            this._process = this.generateProcess(processRepository, requirement);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create process.", e);
        }
        requirement.getStartupListener().notifyProcessStarted(this._process);
        requirement.getStreamListener().notifyProcessStarted(this._process);
        this._monitors = CollectionUtils.asImmutableList((Object[])new Thread[]{this.createOutputMonitorThreadFor(requirement, this._process, this._process.getErrorStream(), StreamType.stderr), this.createOutputMonitorThreadFor(requirement, this._process, this._process.getInputStream(), StreamType.stdout), this.createProcessMonitorThreadFor(requirement, this._process)});
        for (Thread monitor : this._monitors) {
            monitor.start();
        }
        this.waitForSuccessfulStart(requirement);
    }

    @Nonnull
    protected Thread createOutputMonitorThreadFor(@Nonnull R requirement, @Nonnull GeneratedProcess process, @Nonnull InputStream is, @Nonnull StreamType streamType) {
        OutputMonitor<R> monitor = this.createOutputMonitorFor(requirement, process, is, streamType);
        return new Thread(monitor, "OutputMonitor:" + process.getId() + ":" + (Object)((Object)streamType));
    }

    @Nonnull
    protected OutputMonitor<R> createOutputMonitorFor(@Nonnull R requirement, @Nonnull GeneratedProcess process, @Nonnull InputStream is, @Nonnull StreamType streamType) {
        return new OutputMonitor<R>(requirement, process, is, streamType);
    }

    @Nonnull
    protected Thread createProcessMonitorThreadFor(@Nonnull R requirement, @Nonnull GeneratedProcess process) {
        ProcessMonitor<R> monitor = new ProcessMonitor<R>(requirement, process);
        return new Thread(monitor, "ProcessMonitor:" + process.getId());
    }

    @Nonnull
    protected ProcessMonitor<R> createProcessMonitorFor(@Nonnull R requirement, @Nonnull GeneratedProcess process) {
        return new ProcessMonitor<R>(requirement, process);
    }

    protected void waitForSuccessfulStart(@Nonnull R requirement) {
        try {
            StartupListener startupListener = requirement.getStartupListener();
            if (!startupListener.waitForSuccessfulStart()) {
                this.shutdownImmediatelyAfterStart(requirement);
                Throwable e = startupListener.getStartupProblem();
                if (e == null) {
                    e = new CouldNotStartProcessException("Could not successful start process. Output while waiting:\n" + startupListener.getRecordedContentWhileWaiting());
                }
                if (e instanceof CouldNotStartProcessException) {
                    throw (CouldNotStartProcessException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new CouldNotStartProcessException("Could not successful start process. Output while waiting:\n" + startupListener.getRecordedContentWhileWaiting(), e);
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            this.shutdownImmediatelyAfterStart(requirement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownImmediatelyAfterStart(@Nonnull R requirement) {
        try {
            try {
                requirement.getStreamListener().notifyProcessTerminated(this._process);
            }
            finally {
                requirement.getStartupListener().notifyProcessTerminated(this._process);
            }
        }
        finally {
            ResourceUtils.closeQuietly((Object)this);
        }
    }

    @Nonnull
    protected abstract GeneratedProcess generateProcess(@Nonnull ProcessRepository var1, @Nonnull R var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try {
            try {
                this._process.shutdown();
                this._process.waitFor();
                return;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.warn("Could not stop the process. The process will still be on this computer. You have to stop it manually.", (Throwable)e);
                return;
            }
            finally {
                ThreadUtils.stop(this._monitors);
            }
        }
        finally {
            try {
                try {
                    if (this._temporaryDirectory != null) {
                        FileUtils.deleteDirectory((File)this._temporaryDirectory);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Could not delete the temporary directory '" + this._temporaryDirectory + "' with the data values of the process. The files will remain on the disk and still will use disk space. You have to delete it manually.", (Throwable)e);
                }
                finally {
                    this._temporaryDirectory = null;
                }
            }
            finally {
                try {
                    ResourceUtils.closeQuietly((Object)this._requirement.getStartupListener());
                }
                finally {
                    ResourceUtils.closeQuietly((Object)this._requirement.getStreamListener());
                }
            }
        }
    }

    @Nonnull
    public File getExecutable() {
        return this._process.getExecutable();
    }

    public long getPid() {
        return this._process.getId();
    }

    @Nonnull
    public String[] getCommandLine() {
        return this._process.getCommandLine();
    }

    public boolean isAlive() {
        return this.getProcess().isAlive();
    }

    @Nonnull
    protected GeneratedProcess getProcess() {
        return this._process;
    }

    @Nonnull
    protected R getRequirement() {
        return this._requirement;
    }

    @Nonnull
    protected File getBaseDirectoryOfEnvironmentVariable(@Nonnull String name) throws IOException {
        String directoryPath = System.getenv(name);
        if (directoryPath == null) {
            throw new IllegalStateException("In the current environment is no " + name + " environment variable set.");
        }
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it does not exists.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it is not a directory.");
        }
        return directory.getCanonicalFile();
    }

    @Nonnull
    protected File getDirectoryOfEnvironmentVariable(@Nonnull String name, @Nonnull SubPath subPath) throws IOException {
        File directory;
        File baseDirectory = this.getBaseDirectoryOfEnvironmentVariable(name);
        if (subPath == SubPath.inBaseDirectory) {
            directory = baseDirectory;
        } else {
            directory = new File(baseDirectory, subPath.getValue());
            if (!directory.exists()) {
                throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it does not exists.");
            }
            if (!directory.isDirectory()) {
                throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it is not a directory.");
            }
        }
        return directory.getCanonicalFile();
    }

    @Nonnull
    protected File getBinaryOfEnvironmentVariable(@Nonnull String environmentVariableName, @Nonnull SubPath subPath, @Nonnull String binaryFileName) throws IOException {
        File directory = this.getDirectoryOfEnvironmentVariable(environmentVariableName, subPath);
        File binary = new File(directory, binaryFileName);
        if (!binary.canExecute() && !(binary = new File(directory, binaryFileName + ".exe")).canExecute()) {
            throw new IllegalStateException("In the current environment points the " + environmentVariableName + " environment variable to " + directory + " with no " + binaryFileName + " executable in it.");
        }
        return binary;
    }

    @Nonnull
    protected File createTemporaryDirectory(@Nonnull String prefix, @Nonnull String suffix) throws IOException {
        if (this._temporaryDirectory != null) {
            throw new IllegalStateException("There was already a temporary directory created for this process");
        }
        File result = File.createTempFile(prefix, suffix);
        result.delete();
        if (!result.mkdir()) {
            throw new IOException("Could not create temporary directory: " + result);
        }
        result.deleteOnExit();
        this._temporaryDirectory = result;
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{pid=" + this.getPid() + ", alive=" + this.isAlive() + "}";
    }

    public static class OutputMonitor<R extends ApplicationDaemonRequirement<?>>
    implements Runnable {
        @Nonnull
        private final GeneratedProcess _process;
        @Nonnull
        private final R _requirement;
        @Nonnull
        private final InputStream _stream;
        @Nonnull
        private final StreamType _streamType;

        public OutputMonitor(@Nonnull R requirement, @Nonnull GeneratedProcess process, @Nonnull InputStream stream, @Nonnull StreamType streamType) {
            this._requirement = requirement;
            this._process = process;
            this._stream = stream;
            this._streamType = streamType;
        }

        @Override
        public void run() {
            block4: {
                StreamListener streamListener = this._requirement.getStreamListener();
                StartupListener startupListener = this._requirement.getStartupListener();
                InputStreamReader reader = new InputStreamReader(this._stream);
                BufferedReader bufferedReader = new BufferedReader(reader);
                try {
                    String line = bufferedReader.readLine();
                    while (!Thread.currentThread().isInterrupted() && line != null) {
                        startupListener.notifyLineOutput(this._process, line, this._streamType);
                        streamListener.notifyLineOutput(this._process, line, this._streamType);
                        line = bufferedReader.readLine();
                    }
                }
                catch (InterruptedIOException ignored) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    if (e instanceof IOException && "Stream closed".equals(e.getMessage())) break block4;
                    LOG.warn("Could not read from " + this._stream + ".", (Throwable)e);
                }
            }
        }
    }

    public static class ProcessMonitor<R extends ApplicationDaemonRequirement<?>>
    implements Runnable {
        @Nonnull
        private final R _requirement;
        @Nonnull
        private final GeneratedProcess _process;

        public ProcessMonitor(@Nonnull R requirement, @Nonnull GeneratedProcess process) {
            this._requirement = requirement;
            this._process = process;
        }

        @Override
        public void run() {
            try {
                this._process.waitFor();
                this._requirement.getStartupListener().notifyProcessTerminated(this._process);
                this._requirement.getStreamListener().notifyProcessTerminated(this._process);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                try {
                    this._process.shutdown();
                    LOG.info("I was interrupted while waiting for " + this._process + ". This process was successful terminated now.");
                }
                catch (Exception e) {
                    LOG.info("I was interrupted while waiting for " + this._process + ". While I try to terminate this process there was an error produced. In normal case this means, that the process is still running. Now you have to check manually for this zombie process.", (Throwable)e);
                }
            }
        }
    }

    public static enum SubPath {
        inBaseDirectory(null),
        inBinDirectory("bin");

        private final String _value;

        private SubPath(String value) {
            this._value = value;
        }

        @Nullable
        public String getValue() {
            return this._value;
        }
    }
}

