/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.ProcessRepository;
import org.echocat.jomon.process.daemon.ApplicationDaemon;
import org.echocat.jomon.process.daemon.ApplicationDaemonQuery;
import org.echocat.jomon.process.daemon.ApplicationDaemonRequirement;
import org.echocat.jomon.process.daemon.BaseApplicationDaemonQuery;
import org.echocat.jomon.process.daemon.CouldNotStartProcessException;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.IteratorUtils;
import org.echocat.jomon.runtime.repository.InsertingRepository;
import org.echocat.jomon.runtime.repository.QueryableRepository;
import org.echocat.jomon.runtime.repository.RemovingRepository;
import org.echocat.jomon.runtime.util.ResourceUtils;

@ThreadSafe
public class ApplicationDaemonRepository
implements QueryableRepository<BaseApplicationDaemonQuery<?, ?>, Long, ApplicationDaemon<?>>,
Iterable<ApplicationDaemon<?>>,
RemovingRepository<BaseApplicationDaemonQuery<?, ?>, Long>,
InsertingRepository<ApplicationDaemon<?>>,
Generator<ApplicationDaemon<?>, ApplicationDaemonRequirement<?>>,
AutoCloseable {
    private static final ApplicationDaemonRepository INSTANCE = new ApplicationDaemonRepository();
    private final Thread _shutdownHook = new Thread("ShutdownApplicationDaemons"){

        @Override
        public void run() {
            ApplicationDaemonRepository.this.close();
        }
    };
    private final Map<Long, ApplicationDaemon<?>> _idToProcess = new ConcurrentHashMap();
    private final ProcessRepository _processRepository;

    @Nonnull
    public static ApplicationDaemonRepository getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static ApplicationDaemonRepository applicationDaemonRepository() {
        return ApplicationDaemonRepository.getInstance();
    }

    public ApplicationDaemonRepository() {
        this(ProcessRepository.processRepository());
    }

    public ApplicationDaemonRepository(@Nonnull ProcessRepository processRepository) {
        this._processRepository = processRepository;
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
    }

    @Nonnull
    public ApplicationDaemon<?> generate(@Nonnull ApplicationDaemonRequirement<?> requirement) {
        return this.generateDirect(requirement);
    }

    @Nonnull
    public <R extends ApplicationDaemonRequirement<T>, T extends ApplicationDaemon<R>> T generateDirect(@Nonnull R requirement) {
        T applicationDaemon = this.createInstanceFor(requirement);
        this._idToProcess.put(((ApplicationDaemon)applicationDaemon).getPid(), (ApplicationDaemon<?>)applicationDaemon);
        return applicationDaemon;
    }

    public void insert(@Nonnull ApplicationDaemon<?> applicationDaemon) {
        this._idToProcess.put(applicationDaemon.getPid(), applicationDaemon);
    }

    @Nullable
    public ApplicationDaemon<?> findOneBy(@Nonnull Long pid) {
        return this._idToProcess.get(pid);
    }

    @Nullable
    public ApplicationDaemon<?> findOneBy(@Nonnull BaseApplicationDaemonQuery<?, ?> query) {
        return (ApplicationDaemon)CollectionUtils.findFirstOf(this.findBy(query));
    }

    @Nonnull
    public CloseableIterator<ApplicationDaemon<?>> findBy(@Nonnull BaseApplicationDaemonQuery<?, ?> query) {
        return IteratorUtils.filter(this.iterator(), query);
    }

    public long countBy(@Nonnull BaseApplicationDaemonQuery<?, ?> query) {
        return CollectionUtils.countElementsOf(this.iterator(), query);
    }

    public boolean removeBy(@Nonnull Long pid) {
        ApplicationDaemon<?> applicationDaemon = this._idToProcess.remove(pid);
        if (applicationDaemon != null) {
            ResourceUtils.closeQuietly(applicationDaemon);
        }
        return applicationDaemon != null;
    }

    public long removeBy(@Nonnull BaseApplicationDaemonQuery<?, ?> query) {
        long removed = 0L;
        try (CloseableIterator<ApplicationDaemon<?>> i = this.findBy(query);){
            while (i.hasNext()) {
                ApplicationDaemon applicationDaemon = (ApplicationDaemon)i.next();
                long pid = applicationDaemon.getPid();
                if (this._idToProcess.remove(pid) == null) continue;
                ResourceUtils.closeQuietly((Object)applicationDaemon);
                ++removed;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Collection<ApplicationDaemon<?>> getCopySafe() {
        Map<Long, ApplicationDaemon<?>> map = this._idToProcess;
        synchronized (map) {
            return new HashSet(this._idToProcess.values());
        }
    }

    @Override
    public Iterator<ApplicationDaemon<?>> iterator() {
        return this.getCopySafe().iterator();
    }

    @Nonnull
    protected <R extends ApplicationDaemonRequirement<T>, T extends ApplicationDaemon<R>> Constructor<T> getConstructorFor(@Nonnull R requirement) {
        return this.getConstructorFor(requirement.getType(), requirement);
    }

    @Nonnull
    protected <R extends ApplicationDaemonRequirement<T>, T extends ApplicationDaemon<R>> Constructor<T> getConstructorFor(@Nonnull Class<T> type, @Nonnull R requirement) {
        Constructor<T> constructor = null;
        Iterator<Class<?>> i = this.getTypesIteratorFor(requirement);
        while (i.hasNext()) {
            Class<?> requirementType = i.next();
            try {
                constructor = type.getConstructor(ProcessRepository.class, requirementType);
            }
            catch (NoSuchMethodException ignored) {}
        }
        if (constructor == null) {
            try {
                constructor = type.getConstructor(ProcessRepository.class);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
        if (constructor == null) {
            throw new IllegalArgumentException("Could not create application daemon for " + type.getName() + " because could not find a valid constructor like:" + "\n\t" + type.getName() + "(" + ProcessRepository.class.getName() + ", " + requirement.getType().getName() + ")" + "\n\t" + type.getName() + "(" + ProcessRepository.class.getName() + ")");
        }
        return constructor;
    }

    @Nonnull
    protected <R extends ApplicationDaemonRequirement<T>, T extends ApplicationDaemon<R>> T createInstanceFor(@Nonnull R requirement) {
        return this.createInstanceFor(this.getConstructorFor(requirement), requirement);
    }

    @Nonnull
    protected <R extends ApplicationDaemonRequirement<T>, T extends ApplicationDaemon<R>> T createInstanceFor(@Nonnull Constructor<T> constructor, @Nonnull R requirement) {
        ApplicationDaemon result;
        try {
            result = constructor.getParameterTypes().length == 1 ? (ApplicationDaemon)constructor.newInstance(this._processRepository) : (ApplicationDaemon)constructor.newInstance(this._processRepository, requirement);
        }
        catch (Exception e) {
            Throwable cause;
            Throwable target = e instanceof InvocationTargetException ? ((cause = e.getCause()) != null ? cause : e) : e;
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new CouldNotStartProcessException("Could not start application daemon " + requirement.getType().getName() + ".", e);
        }
        return (T)result;
    }

    @Nonnull
    protected Iterator<Class<?>> getTypesIteratorFor(@Nonnull ApplicationDaemonRequirement<?> requirement) {
        return CollectionUtils.asSingletonIterator(requirement.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.removeBy(ApplicationDaemonQuery.applicationDaemon());
        }
        finally {
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }
}

