/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.process.daemon.listeners.startup.StartupListenerSupport;

public class WaitForContentInLineStartupListener
extends StartupListenerSupport<WaitForContentInLineStartupListener> {
    @Nonnull
    private final Pattern _successLinePattern;
    @Nullable
    private Pattern _failLinePattern;

    @Nonnull
    public static WaitForContentInLineStartupListener waitForContentInLine(@Nonnull Pattern successLinePattern) {
        return new WaitForContentInLineStartupListener(successLinePattern);
    }

    @Nonnull
    public static WaitForContentInLineStartupListener waitForContentInLine(@Nonnull String successLinePattern) {
        return WaitForContentInLineStartupListener.waitForContentInLine(Pattern.compile(successLinePattern));
    }

    public WaitForContentInLineStartupListener(@Nonnull Pattern successLinePattern) {
        this._successLinePattern = successLinePattern;
    }

    @Nonnull
    public WaitForContentInLineStartupListener whichFailsOnLineWith(@Nonnull Pattern pattern) {
        this._failLinePattern = pattern;
        return (WaitForContentInLineStartupListener)this.thisListener();
    }

    @Nonnull
    public WaitForContentInLineStartupListener whichFailsOnLineWith(@Nonnull String pattern) {
        return this.whichFailsOnLineWith(Pattern.compile(pattern));
    }

    @Nonnull
    public Pattern getSuccessLinePattern() {
        return this._successLinePattern;
    }

    @Nullable
    public Pattern getFailLinePattern() {
        return this._failLinePattern;
    }

    public void setFailLinePattern(Pattern failLinePattern) {
        this._failLinePattern = failLinePattern;
    }

    @Override
    protected void notifyLineOutputWhileStartup(@Nonnull GeneratedProcess process, @Nonnull String line, @Nonnull StreamType streamType) {
        if (this._successLinePattern.matcher(line).matches()) {
            this.notifyStartupDone(process, true);
        } else {
            Pattern failLinePattern = this._failLinePattern;
            if (failLinePattern != null && failLinePattern.matcher(line).matches()) {
                this.notifyStartupDone(process, false);
            }
        }
    }
}

