/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon.listeners.startup;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.CouldNotStartProcessException;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.process.daemon.listeners.startup.StartupListener;
import org.echocat.jomon.runtime.util.Duration;

public abstract class StartupListenerSupport<L extends StartupListenerSupport<L>>
implements StartupListener {
    private final Lock _lock = new ReentrantLock();
    private final Condition _condition = this._lock.newCondition();
    private final StringBuilder _recordedContentWhileWaiting = new StringBuilder();
    private Duration _maxWaitTimeForStartupOfApplication = new Duration("1m");
    private volatile Boolean _startupDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForSuccessfulStart() throws InterruptedException {
        while (!Thread.currentThread().isInterrupted() && this._startupDone == null) {
            this._lock.lockInterruptibly();
            try {
                if (this._condition.await(this._maxWaitTimeForStartupOfApplication.toMilliSeconds(), TimeUnit.MILLISECONDS)) continue;
                this._startupDone = false;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            finally {
                this._lock.unlock();
            }
        }
        return this._startupDone;
    }

    @Override
    public void notifyProcessStarted(@Nonnull GeneratedProcess process) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProcessTerminated(@Nonnull GeneratedProcess process) {
        this._lock.lock();
        try {
            if (this._startupDone == null) {
                this._startupDone = false;
                this._condition.signalAll();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public Boolean isSuccessfulStarted() {
        return this._startupDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getRecordedContentWhileWaiting() {
        this._lock.lock();
        try {
            if (this._startupDone == null) {
                throw new IllegalStateException("The startup is still in process.");
            }
            String string = this._recordedContentWhileWaiting.toString();
            return string;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLineOutput(@Nonnull GeneratedProcess process, @Nonnull String line, @Nonnull StreamType streamType) {
        if (this._startupDone == null) {
            this._lock.lock();
            try {
                this.notifyLineOutputWhileStartup(process, line, streamType);
                this._recordedContentWhileWaiting.append(line);
                if (!line.endsWith("\n")) {
                    this._recordedContentWhileWaiting.append('\n');
                }
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Throwable getStartupProblem() {
        this._lock.lock();
        try {
            if (this._startupDone == null) {
                throw new IllegalStateException("The startup is still in process.");
            }
            CouldNotStartProcessException result = this._startupDone == false ? new CouldNotStartProcessException("Could not start process. Lines while starting:\n" + this._recordedContentWhileWaiting) : null;
            CouldNotStartProcessException couldNotStartProcessException = result;
            return couldNotStartProcessException;
        }
        finally {
            this._lock.unlock();
        }
    }

    protected void notifyLineOutputWhileStartup(@Nonnull GeneratedProcess process, @Nonnull String line, @Nonnull StreamType streamType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStartupDone(@Nonnull GeneratedProcess process, @Nonnull boolean success) {
        this._lock.lock();
        try {
            if (this._startupDone == null) {
                this._startupDone = success;
                this._condition.signalAll();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Nonnull
    public L whichWaitsForTheStartupUntil(@Nonnull Duration duration) {
        this.setMaxWaitTimeForStartupOfApplication(duration);
        return this.thisListener();
    }

    @Nonnull
    public L whichWaitsForTheStartupUntil(@Nonnegative long duration) {
        return this.whichWaitsForTheStartupUntil(new Duration(duration));
    }

    @Nonnull
    public L whichWaitsForTheStartupUntil(@Nonnull String duration) {
        return this.whichWaitsForTheStartupUntil(new Duration(duration));
    }

    @Nonnull
    public Duration getMaxWaitTimeForStartupOfApplication() {
        return this._maxWaitTimeForStartupOfApplication;
    }

    public void setMaxWaitTimeForStartupOfApplication(Duration maxWaitTimeForStartupOfApplication) {
        this._maxWaitTimeForStartupOfApplication = maxWaitTimeForStartupOfApplication != null ? maxWaitTimeForStartupOfApplication : new Duration("1m");
    }

    @Nonnull
    protected L thisListener() {
        return (L)this;
    }
}

