/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon.listeners.stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListenerProviderSupport;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListenerSupport;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedCountStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.util.ResourceUtils;

@ThreadSafe
public class RedirectToFileStreamListener
extends StreamListenerSupport<RedirectToFileStreamListener> {
    @Nonnull
    private final File _file;
    @Nonnull
    private final RetryForSpecifiedCountStrategy<Void> _strategy = (RetryForSpecifiedCountStrategy)RetryForSpecifiedCountStrategy.retryForSpecifiedCountOf((int)5).withExceptionsThatForceRetry(new Class[]{IOException.class});
    @Nonnull
    private Charset _charset = Charset.defaultCharset();
    private boolean _append;
    @Nullable
    private Writer _writer;

    @Nonnull
    public static RedirectToFileStreamListener redirectToFile(@Nonnull File file) {
        return new RedirectToFileStreamListener(file);
    }

    public RedirectToFileStreamListener(@Nonnull File file) {
        this._file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(@Nonnull GeneratedProcess process, @Nonnull String content, @Nonnull StreamType streamType) {
        try {
            RedirectToFileStreamListener redirectToFileStreamListener = this;
            synchronized (redirectToFileStreamListener) {
                this.writeThrowingIOException(content);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write message to file: " + this._file, e);
        }
    }

    @GuardedBy(value="this")
    protected void writeThrowingIOException(final @Nonnull String content) throws IOException {
        Retryer.executeWithRetry((Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                Writer writer = RedirectToFileStreamListener.this.getWriter();
                try {
                    writer.write(content);
                }
                catch (IOException e) {
                    RedirectToFileStreamListener.this._writer = null;
                    throw e;
                }
                try {
                    writer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }, this._strategy, IOException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @GuardedBy(value="this")
    protected Writer getWriter() throws IOException {
        if (this._writer == null) {
            boolean success = false;
            FileOutputStream os = FileUtils.openOutputStream((File)this._file, (boolean)this._append);
            try {
                this._writer = new OutputStreamWriter((OutputStream)os, this._charset);
                success = true;
            }
            finally {
                if (!success) {
                    ResourceUtils.closeQuietly((Object)os);
                }
            }
        }
        return this._writer;
    }

    @Nonnull
    public RedirectToFileStreamListener withCharset(@Nonnull Charset charset) {
        this._charset = charset;
        return (RedirectToFileStreamListener)this.thisObject();
    }

    @Nonnull
    public RedirectToFileStreamListener withCharset(@Nonnull String charset) {
        return this.withCharset(Charset.forName(charset));
    }

    @Nonnull
    public RedirectToFileStreamListener whichAppendsContent(boolean append) {
        this._append = append;
        return (RedirectToFileStreamListener)this.thisObject();
    }

    @Nonnull
    public RedirectToFileStreamListener whichAppendsContent() {
        return this.whichAppendsContent(true);
    }

    @Nonnull
    public RedirectToFileStreamListener whichNotAppendContent() {
        return this.whichAppendsContent(false);
    }

    @Nonnull
    public RedirectToFileStreamListener withMaximumNumberOfWriteTries(@Nonnegative int tries) {
        this._strategy.withMaxNumberOfRetries(tries);
        return (RedirectToFileStreamListener)this.thisObject();
    }

    @Nonnull
    public Charset getCharset() {
        return this._charset;
    }

    @Nonnull
    public File getFile() {
        return this._file;
    }

    @Nonnegative
    public int getMaxNumberOfWriteTries() {
        return this._strategy.getMaxNumberOfRetries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        try {
            boolean bl = super.isClosed();
            return bl;
        }
        finally {
            RedirectToFileStreamListener redirectToFileStreamListener = this;
            synchronized (redirectToFileStreamListener) {
                try {
                    ResourceUtils.closeQuietly((Object)this._writer);
                }
                finally {
                    this._writer = null;
                }
            }
        }
    }

    public static class Provider
    extends StreamListenerProviderSupport<RedirectToFileStreamListener> {
        public Provider() {
            super(RedirectToFileStreamListener.class, "redirectToFile", "file");
        }

        @Override
        @Nonnull
        protected RedirectToFileStreamListener createInstanceBy(@Nonnull Class<RedirectToFileStreamListener> type, @Nonnull Map<String, String> parameters) {
            return new RedirectToFileStreamListener(new File(parameters.get("file")));
        }

        @Override
        protected void configure(@Nonnull RedirectToFileStreamListener instance, @Nonnull Map<String, String> parameters) {
            super.configure(instance, parameters);
            this.configureCharset(instance, parameters);
            this.configureAppend(instance, parameters);
            this.configureMaxNumberOfWriteTries(instance, parameters);
        }

        protected void configureCharset(@Nonnull RedirectToFileStreamListener instance, @Nonnull Map<String, String> parameters) {
            String value = parameters.get("charset");
            if (value != null) {
                instance.withCharset(value);
            }
        }

        protected void configureAppend(@Nonnull RedirectToFileStreamListener instance, @Nonnull Map<String, String> parameters) {
            instance.whichAppendsContent(this.getBooleanValue(parameters, "append", false));
        }

        protected void configureMaxNumberOfWriteTries(@Nonnull RedirectToFileStreamListener instance, @Nonnull Map<String, String> parameters) {
            String value = parameters.get("maxNumberOfWriteTries");
            if (value != null) {
                instance.withMaximumNumberOfWriteTries(Integer.parseInt(value.trim()));
            }
        }
    }
}

