/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon.listeners.stream;

import java.util.Map;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListenerProviderSupport;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListenerSupport;
import org.echocat.jomon.runtime.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectToLoggerStreamListener
extends StreamListenerSupport<RedirectToLoggerStreamListener> {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectToLoggerStreamListener.class);

    public RedirectToLoggerStreamListener() {
        this.whichFormatsMessagesWith("{message}");
    }

    @Override
    protected void write(@Nonnull GeneratedProcess process, @Nonnull String content, @Nonnull StreamType streamType) {
        for (String partOfLine : StringUtils.split((String)this.removeLastLineBreakFrom(content), (char)'\n')) {
            String formattedLine = "[" + process.getId() + "] " + partOfLine;
            if (streamType == StreamType.stdout) {
                LOG.info(formattedLine);
                continue;
            }
            if (streamType == StreamType.stderr) {
                LOG.error(formattedLine);
                continue;
            }
            if (streamType == StreamType.system) {
                LOG.info(formattedLine);
                continue;
            }
            throw new IllegalArgumentException("Could not handle streamType: " + (Object)((Object)streamType));
        }
    }

    public static class Provider
    extends StreamListenerProviderSupport<RedirectToLoggerStreamListener> {
        public Provider() {
            super(RedirectToLoggerStreamListener.class, "redirectToLogger", new String[0]);
        }

        @Override
        @Nonnull
        protected RedirectToLoggerStreamListener createInstanceBy(@Nonnull Class<RedirectToLoggerStreamListener> type, @Nonnull Map<String, String> parameters) {
            return new RedirectToLoggerStreamListener();
        }
    }
}

