/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon.listeners.stream;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListenerProvider;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListenerSupport;
import org.echocat.jomon.runtime.CollectionUtils;

public abstract class StreamListenerProviderSupport<T extends StreamListenerSupport<T>>
implements StreamListenerProvider {
    @Nonnull
    private final Class<T> _type;
    @Nonnull
    private final String _name;
    @Nonnull
    private final Set<String> _requiredParameters;

    public StreamListenerProviderSupport(@Nonnull Class<T> type, @Nonnull String name, String ... requiredParameters) {
        this(type, name, CollectionUtils.asImmutableSet((Object[])requiredParameters));
    }

    public StreamListenerProviderSupport(@Nonnull Class<T> type, @Nonnull String name, @Nullable Iterable<String> requiredParameters) {
        this._type = type;
        this._name = name;
        this._requiredParameters = CollectionUtils.asImmutableSet(requiredParameters);
    }

    @Nullable
    public T provideFor(@Nonnull String configuration) {
        T result;
        String[] parts = StringUtils.split((String)configuration, (char)'|');
        if (parts.length > 0) {
            if (this._name.equals(parts[0])) {
                Map<String, String> parameters = this.toParameters(parts);
                this.checkForRequiredParameters(parameters);
                result = this.createInstanceBy(this._type, parameters);
                this.configure(result, parameters);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Nonnull
    protected abstract T createInstanceBy(@Nonnull Class<T> var1, @Nonnull Map<String, String> var2);

    protected void configure(@Nonnull T instance, @Nonnull Map<String, String> parameters) {
        this.configureFormatter(instance, parameters);
        this.configureRecordProcessStarted(instance, parameters);
        this.configureRecordProcessTerminated(instance, parameters);
    }

    protected void configureFormatter(@Nonnull T instance, @Nonnull Map<String, String> parameters) {
        String value = parameters.get("pattern");
        if (value != null) {
            ((StreamListenerSupport)instance).whichFormatsMessagesWith(value);
        }
    }

    protected void configureRecordProcessStarted(@Nonnull T instance, @Nonnull Map<String, String> parameters) {
        ((StreamListenerSupport)instance).whichRecordsProcessStart(this.getBooleanValue(parameters, "recordProcessStarted", false));
    }

    protected void configureRecordProcessTerminated(@Nonnull T instance, @Nonnull Map<String, String> parameters) {
        ((StreamListenerSupport)instance).whichRecordsProcessTermination(this.getBooleanValue(parameters, "recordProcessTerminated", false));
    }

    protected boolean getBooleanValue(@Nonnull Map<String, String> parameters, @Nonnull String key, boolean defaultValue) {
        return this.isTrue(parameters.get(key), defaultValue);
    }

    protected boolean isTrue(@Nullable String value, boolean defaultValue) {
        String trimmedValue;
        String string = trimmedValue = value != null ? value.trim() : null;
        boolean result = trimmedValue != null ? trimmedValue.isEmpty() || Boolean.TRUE.toString().equalsIgnoreCase(trimmedValue) : defaultValue;
        return result;
    }

    protected void checkForRequiredParameters(@Nonnull Map<String, String> parameters) {
        TreeSet<String> missingParameters = new TreeSet<String>();
        for (String requiredParameter : this._requiredParameters) {
            if (parameters.containsKey(requiredParameter)) continue;
            missingParameters.add(requiredParameter);
        }
        if (!missingParameters.isEmpty()) {
            throw new IllegalArgumentException("Required parameters missing: " + StringUtils.join((Object[])new Set[]{missingParameters}));
        }
    }

    @Nonnull
    protected Map<String, String> toParameters(@Nonnull String[] parts) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 1; i < parts.length; ++i) {
            String key;
            String[] part = StringUtils.split((String)parts[i], (String)"=", (int)2);
            if (part.length < 1 || (key = part[0].trim()).isEmpty()) continue;
            result.put(key, part.length >= 2 ? part[1] : "");
        }
        return result;
    }
}

