/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon.listeners.stream;

import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.ProcessUtils;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListener;
import org.echocat.jomon.process.daemon.listeners.support.DefaultMessageFormatter;
import org.echocat.jomon.process.daemon.listeners.support.MessageFormatter;
import org.echocat.jomon.runtime.CollectionUtils;

@ThreadSafe
public abstract class StreamListenerSupport<T extends StreamListenerSupport<T>>
implements StreamListener,
Closeable {
    public static final String[] KEYS = new String[]{"timeStamp", "streamType", "message", "pid"};
    @Nonnull
    private MessageFormatter _formatter = DefaultMessageFormatter.messageFormatterFor("[{timeStamp,date,yyyy-MM-dd HH:mm:ss} {streamType}] {message}\n", KEYS);
    private boolean _recordProcessStarted;
    private boolean _recordProcessTerminated;
    private volatile boolean _closed;
    private boolean _started;
    private boolean _terminated;

    @Nonnull
    public T whichFormatsMessagesWith(@Nonnull MessageFormatter formatter) {
        this._formatter = formatter;
        return this.thisObject();
    }

    @Nonnull
    public T whichFormatsMessagesWith(@Nonnull String pattern, @Nonnull Locale locale) {
        return this.whichFormatsMessagesWith(DefaultMessageFormatter.messageFormatterFor(pattern, locale, KEYS));
    }

    @Nonnull
    public T whichFormatsMessagesWith(@Nonnull String pattern) {
        return this.whichFormatsMessagesWith(DefaultMessageFormatter.messageFormatterFor(pattern, KEYS));
    }

    @Nonnull
    public T whichRecordsProcessStart(boolean record) {
        this._recordProcessStarted = record;
        return this.thisObject();
    }

    @Nonnull
    public T whichRecordsProcessStart() {
        return this.whichRecordsProcessStart(true);
    }

    @Nonnull
    public T whichNotRecordsProcessStart() {
        return this.whichRecordsProcessStart(false);
    }

    @Nonnull
    public T whichRecordsProcessTermination(boolean record) {
        this._recordProcessTerminated = record;
        return this.thisObject();
    }

    @Nonnull
    public T whichRecordsProcessTermination() {
        return this.whichRecordsProcessTermination(true);
    }

    @Nonnull
    public T whichNotRecordsProcessTermination() {
        return this.whichRecordsProcessTermination(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProcessStarted(@Nonnull GeneratedProcess process) {
        StreamListenerSupport streamListenerSupport = this;
        synchronized (streamListenerSupport) {
            if (!this._started) {
                if (this._recordProcessStarted) {
                    this.formatAndWrite(process, "Process #" + process.getId() + " started: " + ProcessUtils.toEscapedCommandLine(process.getCommandLine()), StreamType.system);
                }
                this._started = true;
            }
        }
    }

    @Override
    public void notifyLineOutput(@Nonnull GeneratedProcess process, @Nonnull String line, @Nonnull StreamType streamType) {
        this.formatAndWrite(process, line, streamType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProcessTerminated(@Nonnull GeneratedProcess process) {
        StreamListenerSupport streamListenerSupport = this;
        synchronized (streamListenerSupport) {
            if (!this._terminated) {
                if (this._recordProcessTerminated) {
                    this.formatAndWrite(process, "Process #" + process.getId() + " ended with exitCode: " + process.exitValue(), StreamType.system);
                }
                this._terminated = true;
            }
        }
    }

    protected void formatAndWrite(@Nonnull GeneratedProcess process, @Nonnull String line, @Nonnull StreamType streamType) {
        if (this._closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.write(process, this.format(process, line, streamType), streamType);
    }

    protected abstract void write(@Nonnull GeneratedProcess var1, @Nonnull String var2, @Nonnull StreamType var3);

    @Nonnull
    protected String format(@Nonnull GeneratedProcess process, @Nonnull String line, @Nonnull StreamType streamType) {
        return this._formatter.format(CollectionUtils.asMap((Object[])new Object[]{"pid", process.getId(), "timeStamp", new Date(), "streamType", streamType, "message", this.removeLastLineBreakFrom(line)}));
    }

    @Nonnull
    protected String removeLastLineBreakFrom(@Nonnull String step0) {
        String step1 = step0.endsWith("\n") ? step0.substring(0, step0.length() - 1) : step0;
        String step2 = step1.endsWith("\r") ? step1.substring(0, step1.length() - 1) : step1;
        String step3 = step2.endsWith("\n") ? step2.substring(0, step1.length() - 2) : step2;
        return step3;
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Nonnull
    public MessageFormatter getFormatter() {
        return this._formatter;
    }

    public boolean isRecordProcessStarted() {
        return this._recordProcessStarted;
    }

    public boolean isRecordProcessTerminated() {
        return this._recordProcessTerminated;
    }

    public boolean isClosed() {
        return this._closed;
    }

    @Nonnull
    protected T thisObject() {
        return (T)this;
    }
}

