/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon.listeners.stream;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.process.daemon.listeners.stream.CompoundStreamListenerProvider;
import org.echocat.jomon.process.daemon.listeners.stream.RedirectToConsoleStreamListener;
import org.echocat.jomon.process.daemon.listeners.stream.RedirectToLoggerStreamListener;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListener;
import org.echocat.jomon.process.daemon.listeners.stream.StreamListenerProvider;

public class StreamListeners {
    private static final StreamListenerProvider PROVIDER = new CompoundStreamListenerProvider(true, new StreamListenerProvider[0]);
    public static final StreamListener redirectToConsole = new ReadOnlyStreamListener(new RedirectToConsoleStreamListener());
    public static final StreamListener redirectToLogger = new ReadOnlyStreamListener(new RedirectToLoggerStreamListener());

    @Nullable
    public static StreamListener streamListenerFor(@Nullable String configuration) {
        return StreamListeners.streamListenerFor(configuration, null);
    }

    @Nullable
    public static StreamListener streamListenerFor(@Nullable String configuration, @Nullable StreamListener fallback) {
        StreamListener result = configuration != null ? PROVIDER.provideFor(configuration) : null;
        return result != null ? result : fallback;
    }

    private StreamListeners() {
    }

    public static class ReadOnlyStreamListener
    implements StreamListener {
        private final StreamListener _delegate;

        public ReadOnlyStreamListener(@Nonnull StreamListener delegate) {
            this._delegate = delegate;
        }

        @Override
        public void notifyProcessStarted(@Nonnull GeneratedProcess process) {
            this._delegate.notifyProcessStarted(process);
        }

        @Override
        public void notifyLineOutput(@Nonnull GeneratedProcess process, @Nonnull String line, @Nonnull StreamType streamType) {
            this._delegate.notifyLineOutput(process, line, streamType);
        }

        @Override
        public void notifyProcessTerminated(@Nonnull GeneratedProcess process) {
            this._delegate.notifyProcessTerminated(process);
        }
    }
}

