/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.GeneratedProcessRequirement;
import org.echocat.jomon.process.ProcessRepository;
import org.echocat.jomon.process.daemon.StreamType;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessExecuter {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessExecuter.class);
    @Nonnull
    private final ProcessRepository _processRepository;
    @Nonnegative
    private int _readSize = 4096;

    public ProcessExecuter() {
        this(ProcessRepository.processRepository());
    }

    public ProcessExecuter(@Nonnull ProcessRepository processRepository) {
        this._processRepository = processRepository;
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public Response execute(@Nonnull GeneratedProcessRequirement requirement) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public ProcessExecuter withReadSize(@Nonnegative int readSize) {
        this.setReadSize(readSize);
        return this;
    }

    public void setReadSize(@Nonnegative int readSize) {
        this._readSize = readSize;
    }

    @Nonnegative
    public int getReadSize() {
        return this._readSize;
    }

    protected class OutputMonitor
    extends Thread
    implements AutoCloseable {
        private final StringBuilder _buffer;
        private final ThreadLocal<Boolean> _alreadyInClosing;
        private final InputStream _stream;
        private final Lock _lock;
        private final Condition _condition;
        private boolean _alive;

        public OutputMonitor(@Nonnull GeneratedProcess process, StreamType streamType) {
            super("OutputMonitor:" + process.getId() + ":" + (Object)((Object)streamType));
            this._buffer = new StringBuilder();
            this._alreadyInClosing = new ThreadLocal();
            this._lock = new ReentrantLock();
            this._condition = this._lock.newCondition();
            this._alive = true;
            this.setDaemon(true);
            this._stream = streamType == StreamType.stdout ? process.getInputStream() : process.getErrorStream();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._lock.lockInterruptibly();
                try {
                    InputStreamReader reader = new InputStreamReader(this._stream);
                    try {
                        char[] buf = new char[ProcessExecuter.this._readSize];
                        int read = reader.read(buf);
                        while (!OutputMonitor.currentThread().isInterrupted() && read >= 0) {
                            this._buffer.append(buf, 0, read);
                            read = reader.read(buf);
                        }
                    }
                    catch (InterruptedIOException ignored) {
                        OutputMonitor.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        if (!(e instanceof IOException) || !"Stream closed".equals(e.getMessage())) {
                            LOG.warn("Could not read from " + this._stream + ".", (Throwable)e);
                        }
                    }
                }
                finally {
                    try {
                        this._alive = false;
                        this._condition.signalAll();
                    }
                    finally {
                        this._lock.unlock();
                    }
                }
            }
            catch (InterruptedException ignored) {
                OutputMonitor.currentThread().interrupt();
            }
            finally {
                ResourceUtils.closeQuietly((Object)this._stream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public String getRecordedContent() {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                return this._buffer.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() throws InterruptedException {
            this._lock.lockInterruptibly();
            try {
                while (this._alive) {
                    this._condition.await(500L, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!Boolean.TRUE.equals(this._alreadyInClosing.get())) {
                this._alreadyInClosing.set(Boolean.TRUE);
                try {
                    try {
                        ResourceUtils.closeQuietly((Object)this._stream);
                    }
                    finally {
                        ThreadUtils.stop((Thread)this);
                    }
                }
                finally {
                    this._alreadyInClosing.remove();
                }
            }
        }
    }

    public static class Response {
        @Nonnull
        private final String _stdout;
        @Nonnull
        private final String _stderr;
        @Nonnegative
        private final int _exitCode;

        public Response(@Nonnull String stdout, @Nonnull String stderr, @Nonnegative int exitCode) {
            this._stdout = stdout;
            this._stderr = stderr;
            this._exitCode = exitCode;
        }

        @Nonnull
        public String getStdout() {
            return this._stdout;
        }

        @Nonnull
        public String getStderr() {
            return this._stderr;
        }

        @Nonnegative
        public int getExitCode() {
            return this._exitCode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{exitCode:" + this._exitCode + "}";
        }

        public boolean wasSuccessful() {
            return this.getExitCode() == 0;
        }

        public boolean hasErrorOutput() {
            return !this.getStderr().trim().isEmpty();
        }

        public boolean isStdoutMatching(@Nonnull Pattern pattern) {
            return pattern.matcher(this.getStdout()).matches();
        }

        public boolean isStdoutMatching(@Nonnull String pattern) {
            return this.isStdoutMatching(Pattern.compile(pattern));
        }

        public boolean isStderrMatching(@Nonnull Pattern pattern) {
            return pattern.matcher(this.getStderr()).matches();
        }

        public boolean isStderrMatching(@Nonnull String pattern) {
            return this.isStderrMatching(Pattern.compile(pattern));
        }
    }
}

