/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.sigar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarInitializer {
    private static final String SIGAR_VERSION = "1.6.4";
    private static final String BINARIES_PACKAGE_DIRECTORY_NAME = "sigarBinaries" + File.separator + "1.6.4";
    private static final String BINARIES_PACKAGE_FILE_NAME = "sigarBinaries-1.6.4.zip";
    private static boolean c_initialized;

    public static synchronized void initializeSigar() {
        if (!c_initialized) {
            File directory = SigarInitializer.getDirectory();
            try {
                SigarInitializer.copyFilesTo(directory);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy sigarBinaries-1.6.4.zip to " + directory + ".", e);
            }
            SigarInitializer.setLibraryPath(directory);
            try {
                Sigar.load();
            }
            catch (SigarException e) {
                throw new RuntimeException("Could not load sigar.", e);
            }
            c_initialized = true;
        }
    }

    @Nonnull
    private static File getDirectory() {
        String temporaryDirectoryPath = System.getProperty("java.io.tmpdir", "tmp");
        File temporaryDirectory = new File(temporaryDirectoryPath);
        File sigarDirectory = new File(temporaryDirectory, BINARIES_PACKAGE_DIRECTORY_NAME);
        sigarDirectory.mkdirs();
        return sigarDirectory;
    }

    private static void copyFilesTo(@Nonnull File directory) throws IOException {
        try (InputStream is = SigarInitializer.class.getResourceAsStream(BINARIES_PACKAGE_FILE_NAME);){
            if (is == null) {
                throw new IllegalArgumentException("Could not find file: sigarBinaries-1.6.4.zip");
            }
            try (ZipInputStream zip = new ZipInputStream(is);){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    File destinationFile;
                    if (!entry.isDirectory() && !(destinationFile = new File(directory, entry.getName())).exists()) {
                        destinationFile.getParentFile().mkdirs();
                        try (FileOutputStream os = new FileOutputStream(destinationFile);){
                            IOUtils.copy((InputStream)zip, (OutputStream)os);
                        }
                    }
                    entry = zip.getNextEntry();
                }
            }
        }
    }

    private static void setLibraryPath(@Nonnull File directory) {
        System.setProperty("org.hyperic.sigar.path", directory.getPath());
    }

    private SigarInitializer() {
    }
}

