/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.sigar;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.Process;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

@ThreadSafe
public class SigarProcess
implements Process {
    private final long _pid;
    private final Sigar _sigar;
    private volatile boolean _execResolved;
    private volatile boolean _argsResolved;
    private volatile File _executable;
    private String[] _commandLine;

    public SigarProcess(long pid, @Nonnull Sigar sigar) {
        this._pid = pid;
        this._sigar = sigar;
    }

    @Override
    public long getId() {
        return this._pid;
    }

    @Override
    @Nullable
    public File getExecutable() {
        this.resolveExecIfNeeded();
        return this._executable;
    }

    @Override
    @Nullable
    public String[] getCommandLine() {
        this.resolveArgsIfNeeded();
        return this._commandLine;
    }

    @Override
    public boolean isPathCaseSensitive() {
        return false;
    }

    protected void resolveExecIfNeeded() {
        if (!this._execResolved) {
            try {
                ProcExe procExe = this._sigar.getProcExe(this._pid);
                String name = procExe.getName();
                File file = new File(name);
                if (file.isFile()) {
                    this._executable = file;
                }
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
            this._execResolved = true;
        }
    }

    protected void resolveArgsIfNeeded() {
        if (!this._argsResolved) {
            try {
                this._commandLine = this._sigar.getProcArgs(this._pid);
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
            this._argsResolved = true;
        }
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof SigarProcess)) {
            result = false;
        } else {
            SigarProcess that = (SigarProcess)o;
            result = this._pid == that._pid;
        }
        return result;
    }

    public int hashCode() {
        return (int)(this._pid ^ this._pid >>> 32);
    }

    public String toString() {
        return "Process #" + this._pid;
    }
}

