/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.sigar;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.AccessDeniedException;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.GeneratedProcessRegistry;
import org.echocat.jomon.process.Process;
import org.echocat.jomon.process.ProcessQuery;
import org.echocat.jomon.process.ProcessRepository;
import org.echocat.jomon.process.Signal;
import org.echocat.jomon.process.sigar.SigarInitializer;
import org.echocat.jomon.process.sigar.SigarProcess;
import org.echocat.jomon.runtime.concurrent.Daemon;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.iterators.IteratorUtils;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SigarProcessRepository
extends ProcessRepository {
    private static final Map<Long, Long> ONE_LONG_INSTANCE = new WeakHashMap<Long, Long>();
    private static final Logger LOG = LoggerFactory.getLogger(SigarProcessRepository.class);
    private final KillDaemonsOfDeadProcesses _killDaemonsOfDeadProcesses = new KillDaemonsOfDeadProcesses();
    private Sigar _sigar;
    private GeneratedProcessRegistry _generatedProcessRegistry;
    private Daemon _killDaemonsOfDeadProcessesDaemon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Process findOneBy(@Nonnull Long id) {
        SigarProcess process;
        Long idInstance;
        Map<Long, Long> map = ONE_LONG_INSTANCE;
        synchronized (map) {
            idInstance = ONE_LONG_INSTANCE.get(id);
            if (idInstance == null && id != null) {
                ONE_LONG_INSTANCE.put(id, id);
                idInstance = id;
            }
        }
        try {
            Long l = idInstance;
            synchronized (l) {
                this._sigar.getProcState(idInstance.longValue());
            }
            process = new SigarProcess(id, this._sigar);
        }
        catch (SigarException ignored) {
            process = null;
        }
        return process;
    }

    @Nonnull
    public CloseableIterator<Process> findBy(@Nonnull ProcessQuery query) {
        Object result;
        List<Long> ids = query.getIds();
        if (ids != null) {
            result = new ToProcessConvertingIterator(ids);
        } else {
            try {
                result = new KnownIdsProcessIterator(this._sigar.getProcList(), this._sigar);
            }
            catch (SigarException e) {
                throw new RuntimeException("Could not get process list for " + query + ".", e);
            }
        }
        return IteratorUtils.filter((Iterator)result, (Predicate)query);
    }

    @Override
    @Nonnull
    protected GeneratedProcess toControllableProcess(@Nonnull Process placeHolder, @Nonnull java.lang.Process original, boolean isDaemon) {
        GeneratedProcess result = super.toControllableProcess(placeHolder, original, isDaemon);
        this._generatedProcessRegistry.register(result);
        return result;
    }

    @Override
    public void send(@Nonnull Process to, @Nonnull Signal signal) {
        int code;
        if (signal == Signal.terminate) {
            code = 15;
        } else if (signal == Signal.kill) {
            code = 9;
        } else if (signal == Signal.interrupt) {
            code = 2;
        } else {
            throw new IllegalArgumentException("Could not handle signal: " + (Object)((Object)signal));
        }
        try {
            this._sigar.kill(to.getId(), code);
        }
        catch (SigarPermissionDeniedException e) {
            throw new AccessDeniedException("Could not kill: " + to, e);
        }
        catch (SigarException e) {
            throw new RuntimeException("Could not kill: " + to, e);
        }
    }

    @Override
    protected boolean couldHandleThisVirtualMachine() {
        boolean result;
        try {
            SigarInitializer.initializeSigar();
            result = true;
        }
        catch (Exception e) {
            LOG.info("Could not load sigar.", (Throwable)e);
            result = false;
        }
        return result;
    }

    @Override
    protected long getCurrentJvmId() {
        return this._sigar.getPid();
    }

    @Override
    protected void init() {
        if (this._sigar != null || this._generatedProcessRegistry != null) {
            this.close();
        }
        SigarInitializer.initializeSigar();
        this._sigar = new Sigar();
        this._generatedProcessRegistry = new GeneratedProcessRegistry(this._sigar.getPid());
        this.startDaemons();
    }

    protected void startDaemons() {
        Daemon daemon = new Daemon((Runnable)this._killDaemonsOfDeadProcesses);
        daemon.setInterval(new Duration("1m"));
        try {
            daemon.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start killDaemonsOfDeadProcessesDaemon.", e);
        }
        daemon.run();
        this._killDaemonsOfDeadProcessesDaemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            ResourceUtils.closeQuietly((Object)this._generatedProcessRegistry);
        }
        finally {
            try {
                ResourceUtils.closeQuietly((Object)this._killDaemonsOfDeadProcessesDaemon);
            }
            catch (Throwable throwable) {
                try {
                    Sigar sigar = this._sigar;
                    if (sigar != null) {
                        sigar.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                Sigar sigar = this._sigar;
                if (sigar != null) {
                    sigar.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nonnull
    protected static SigarProcess toProcess(long pid, @Nonnull Sigar sigar) {
        return new SigarProcess(pid, sigar);
    }

    protected class KillDaemonsOfDeadProcesses
    implements Runnable {
        protected KillDaemonsOfDeadProcesses() {
        }

        @Override
        public void run() {
            Sigar sigar = SigarProcessRepository.this._sigar;
            if (sigar != null) {
                for (long parentProcessId : GeneratedProcessRegistry.getParentProcessIds()) {
                    if (SigarProcessRepository.this.findOneBy(parentProcessId) != null) continue;
                    try (GeneratedProcessRegistry registry = new GeneratedProcessRegistry(parentProcessId);){
                        for (Long processId : registry.getAllIds()) {
                            try {
                                sigar.kill(processId.longValue(), 9);
                            }
                            catch (SigarException ignored) {}
                        }
                    }
                }
            }
        }
    }

    protected static class KnownIdsProcessIterator
    implements CloseableIterator<Process> {
        private final long[] _pids;
        private final Sigar _sigar;
        private int _index;

        public KnownIdsProcessIterator(@Nonnull long[] pids, @Nonnull Sigar sigar) {
            this._pids = pids;
            this._sigar = sigar;
        }

        public void close() {
        }

        public boolean hasNext() {
            return this._index < this._pids.length;
        }

        public Process next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long pid = this._pids[this._index++];
            return SigarProcessRepository.toProcess(pid, this._sigar);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ToProcessConvertingIterator
    extends ConvertingIterator<Long, Process> {
        public ToProcessConvertingIterator(Iterable<Long> ids) {
            this(ids.iterator());
        }

        public ToProcessConvertingIterator(Iterator<Long> ids) {
            super(ids);
        }

        protected Process convert(@Nullable Long id) {
            return id != null ? SigarProcessRepository.this.findOneBy(id) : null;
        }
    }
}

