/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.testing.environments;

import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.jomon.spring.testing.environments.BeanEnvironment;
import org.echocat.jomon.testing.environments.LogEnvironment;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.context.ConfigurableApplicationContext;

public class TestingEnvironment
implements TestRule {
    private final Object _baseObject;
    private BeanEnvironment _beanEnvironment;

    public TestingEnvironment(@Nonnull Object baseObject) {
        this._baseObject = baseObject;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LogEnvironment logEnvironment = new LogEnvironment(TestingEnvironment.this._baseObject);
                try {
                    BeanEnvironment beanEnvironment = new BeanEnvironment(TestingEnvironment.this._baseObject);
                    try {
                        TestingEnvironment.this._beanEnvironment = beanEnvironment;
                        base.evaluate();
                    }
                    finally {
                        try {
                            ResourceUtils.closeQuietly((Object)((Object)beanEnvironment));
                        }
                        finally {
                            TestingEnvironment.this._beanEnvironment = null;
                        }
                    }
                }
                finally {
                    ResourceUtils.closeQuietly((Object)logEnvironment);
                }
            }
        };
    }

    @Nonnull
    public ConfigurableApplicationContext getApplicationContext() {
        return this._beanEnvironment.getApplicationContext();
    }
}

