/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AutomaticServicesDiscovery<V, C extends Collection<V>>
implements FactoryBean<C>,
ApplicationContextAware {
    private final Class<V> _expectedType;
    private ApplicationContext _applicationContext;
    private Collection<Class<?>> _excludes;

    protected AutomaticServicesDiscovery(@Nonnull Class<V> expectedType) {
        this._expectedType = expectedType;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this._applicationContext = applicationContext;
    }

    protected abstract boolean isApplicable(@Nonnull Class<?> var1, @Nonnull String var2, @Nonnull ApplicationContext var3);

    protected abstract C createNewCollection();

    public C getObject() throws Exception {
        String[] names;
        C values = this.createNewCollection();
        for (String name : names = this._applicationContext.getBeanDefinitionNames()) {
            Class<?> type = this.getTypeFor(name);
            if (type == null || !this.isApplicable(type, name, this._applicationContext) || this.isExcluded(type)) continue;
            values.add((Object)this._applicationContext.getBean(name, this._expectedType));
        }
        return values;
    }

    protected boolean isExcluded(@Nonnull Class<?> type) {
        boolean excluded = false;
        if (this._excludes != null) {
            for (Class<?> exclude : this._excludes) {
                if (!exclude.isAssignableFrom(type)) continue;
                excluded = true;
                break;
            }
        }
        return excluded;
    }

    @Nullable
    protected Class<?> getTypeFor(@Nonnull String name) {
        Class<?> type;
        if (this._applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this._applicationContext).getBeanFactory();
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            if (definition != null && definition.getFactoryMethodName() == null) {
                String beanClassName = definition.getBeanClassName();
                if (beanClassName != null) {
                    try {
                        type = AutomaticServicesDiscovery.class.getClassLoader().loadClass(beanClassName);
                    }
                    catch (ClassNotFoundException ignored) {
                        type = null;
                    }
                } else {
                    type = null;
                }
            } else {
                type = null;
            }
        } else {
            throw new IllegalArgumentException("Currently there is only an applicationContext of type " + ConfigurableApplicationContext.class.getName() + " supported.");
        }
        return type == null || FactoryBean.class.isAssignableFrom(type) ? null : type;
    }

    public Collection<Class<?>> getExcludes() {
        return this._excludes;
    }

    public void setExcludes(Collection<Class<?>> excludes) {
        this._excludes = excludes;
    }

    public Class<?> getObjectType() {
        return this.createNewCollection().getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

